/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef	_CONFIG_
#define	_CONFIG_

#define VERSION		pem_version()
#define COPYRIGHT	pem_copyright()


/* Categorize the OS as System V or Berkeley derived.
 * In addition define any operating specific patches
 */


/* Sun Systems */

#ifdef	SUNOS4
#ifndef	BSD43
#define BSD43
#endif	/* not BSD43 */
#include <fcntl.h>
#endif	/* SUNOS4 */

#ifdef	SUNOS3
#ifndef	BSD42
#define	BSD42
#endif	/* not BSD42 */
#endif	/* SUNOS3 */


/* Berkeley Systems */

#ifdef	BSD43
#ifndef	BSD42
#define	BSD42
#endif	/* not BSD42 */
#endif	/* BSD43 */

#ifdef	BSD42
#include <sys/time.h>
#ifndef	_BSD_
#define	_BSD_
#endif	/* not _BSD_ */
#else	/* not BSD42 */
#include <time.h>
#endif	/* BSD42 */


/* NeXT Systems */

#ifdef	NeXT
#ifndef	MACH
#define	MACH
#endif	/* not MACH */
#endif	/* NeXT */


/* SYS5 Systems */

#ifdef	SYS5
#ifndef	_SYS5_
#define	_SYS5_
#endif	/* not _SYS5_ */
#endif	/* SYS5 */



/* MACH (on NeXT) */

#ifdef	MACH

#define	const
#define	volatile

#include <sys/malloc.h>
#include <libc.h>

#define	DIRECT

#ifndef	_BSD_
#define	_BSD_
#endif	/* not _BSD_ */

#else	/* not MACH */
#define	DIRENT

#endif	/* MACH */



/* Trusted Xenix */

#ifdef	TXENIX
#ifndef	_SYS5_
#define	_SYS5_
#endif	/* not _SYS5_ */

#define register
#endif	/* TXENIX */



/* Things needed for Berkeley derived systems in general */

#ifdef	_BSD_

/* MACH peculiarity */

#ifndef	MACH
#include <malloc.h>
extern char *calloc();
#endif	/* not MACH */

#include <sys/types.h>
#include <sys/file.h>

extern time_t time();
#define TIME()			(long) time((time_t *)0)

#include <sys/wait.h>
#define WAIT()			wait((union wait *)0)

#define BCMP(b1,b2,length)	bcmp((char *)(b1), (char *)(b2), (int)length)
#define BCOPY(b1,b2,length)	bcopy((char *)(b1), (char *)(b2), (int)length)
#define BZERO(b,length)		bzero((char *)(b), (int)length)

#include <strings.h>
#define INDEX(s, c)		index((char *)s, (int)c)
#define RINDEX(s, c)		rindex((char *)s, (int)c)

extern char *sprintf();
extern char *strdup();

extern off_t lseek();

#endif	/* _BSD_ */



/* Things needed for System V derived systems in general */
#ifdef	_SYS5_

#include <sys/types.h>
#include <fcntl.h>

#define _IOSTRG			0100
#define VSPRINTF

extern off_t lseek();

extern long time();
#define TIME()			(long) time((long *)0)

#define WAIT()			wait((int *)0)

#include <memory.h>
#define BCMP(b1,b2,length)	memcmp((char *)(b1), (char *)(b2), (int)length)
#define BCOPY(b1,b2,length)     memcpy((char *)(b2), (char *)(b1), (int)length)
#define BZERO(b,length)         memset((char *)(b), 0, (int)length)

#include <string.h>
#define rindex			strrchr
#define index			strchr
#define INDEX(s, c)		index((char *)s, (int)c)
#define RINDEX(s, c)		rindex((char *)s, (int)c)

#define random()		rand()
#define srandom(x)		srand(x)

extern struct passwd		*getpwuid();

#ifndef	BSDI
extern char *calloc();
extern char *malloc();
extern char *realloc();
#endif	/* BSDI */

#endif	/* _SYS5_ */



/* Include the correct directory access routines/structures */

#ifdef	DIRECT
#include <sys/dir.h>
#endif	/* DIRECT */

#ifdef	DIRENT
#include <dirent.h>
#endif	/* DIRENT */

#endif	/* not _CONFIG_ */
