/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"


static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

static user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}


main(argc, argv)
int	argc;
char  **argv;
{
    char	    **av = NULLVP,
                    **avp = NULLVP,
		    **user = NULLVP;
    struct cbstruct   iocbs;
    int               done = 0;
    int               found;
    int               login, logout, logcheck;
    
    if (pem_init(argc, argv, &av) != OK) {
	(void) fprintf(stderr, "%s: initialization failure\n", *argv);
	exit(1);
    }

    login = !strcasecmp(myname, "pemlogin");
    logout = !strcasecmp(myname, "pemlogout");
    logcheck = !strcasecmp(myname, "pemlogchk") ||
	       !strcasecmp(myname, "pemlogcheck");

    if ((argc > 1 && !strcmp(*(argv+1), "help")) ||
	(!login && !logout && !logcheck)) {
	(void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: pemlogin    [alias <alias> ...]\n");
	(void) fprintf(stderr, "       pemlogout   [alias <alias> ...]\n");
	(void) fprintf(stderr, "       pemlogchk   [alias <alias> ...]\n");
	(void) fprintf(stderr, "       pemlogcheck [alias <alias> ...]\n");
	exit(1);
    }

    /* initialize callbacks */

    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.ne_user = user_ne;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;

    if (av != NULLVP) {
	for (avp = av; *avp != NULLCP && !strcasecmp(*avp,"alias"); avp +=2) {
	    rewind_indexfile();
	    found = 0;
	    while ((user = get_tv_user(*avp, *(avp+1))) != NULLVP) {
		found = 1;
		if (login) done = pem_login(user, &iocbs);
		if (logout) done = pem_logout(user, &iocbs);
		if (logcheck) done = pem_logchk(user, &iocbs);
		FREE_AV(user);
		if (done != OK) goto cleanup;
	    }
	    if (!found) {
		fprintf(stderr, "%s: Unable to find user with alias \"%s\".\n",
			myname, *(avp+1));
		goto cleanup;
	    }
	}
	if (*avp != NULLCP) {
	    fprintf(stderr, "%s: Unknown tag/value pair \"%s %s\".\n",
                        myname, *avp, *(avp+1));
	    goto cleanup;
	}
    }
    else {
	if (login) {
	    if ((avp = tag_user(user_tailor, "sig-alias")) == NULLVP) {
		fprintf(stderr, "%s: No sig-alias defined.\n", myname);
		goto cleanup;
	    }
	    rewind_indexfile();
	    if ((user = get_tv_user("alias", *(avp+1))) == NULLVP) {
		fprintf(stderr, "%s: Unable to find user with alias \"%s\".\n",
			myname, *(avp+1));
		goto cleanup;
	    }
	    done = pem_login(user, &iocbs);
	    FREE_AV(user);
	}
	if (logout) 
	    done = pem_logout(NULLVP, &iocbs);
	if (logcheck) 
	   done = pem_logchk(NULLVP, &iocbs);
	if (done != OK) 
	    goto cleanup;
    }

 cleanup:
	    
    exit(done);

}
