/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include <stdio.h>


struct program {
    char *name;
    int (*function)();
};

extern int sign_main(), verify_main(), encrypt_main(), decrypt_main(),
    savekeydata_main(), getkeydata_main(), mosskey_main(),
    mosskeysign_main(), mosscrl_main(), mossdisp_main(), mossdisp_main(),
    mosslo_main(), mosspass_main(), mossvalidate_main();

static struct program programs[] =  {
{"sign", sign_main},
{"verify", verify_main},
{"encrypt", encrypt_main},
{"decrypt", decrypt_main},
{"savekeydata", savekeydata_main},
{"getkeydata", getkeydata_main},
{"mosskey", mosskey_main},
{"mosskeysign", mosskeysign_main},
{"mosscrl", mosscrl_main},
{"mossdisp", mossdisp_main},
{"mosslogin", mosslo_main},
{"mosslogout", mosslo_main},
{"mosslogcheck", mosslo_main},
{"mosspass", mosspass_main},
{"mossvalidate", mossvalidate_main},
{NULLCP, mossvalidate_main}
};

main (argc, argv)
int argc;
char **argv;

{
    char *cp;
    int exitcode;
    struct program *progptr;
    
    if ((cp = RINDEX(*argv, PATH_SEP)) == NULLCP)
        myname = *argv;
    else
        myname = ++cp;

    for (progptr = programs; 
	 progptr->name != NULLCP && strcmp(myname, progptr->name);
	 progptr++)
	;

    if (progptr->name != NULLCP)
	exitcode = progptr->function(argc, argv);
    else {
	fprintf(stderr, 
	"\nThis program determines which %s function to perform based\n",
		PACKAGE);
	fprintf(stderr,
	"on the name by which it is invoked.  A symbolic or hard link with\n");
	fprintf(stderr,
        "the name of a %s function is required.\n\n", PACKAGE);
	fprintf(stderr, 
		"\"%s\" is an unknown function.  Legal functions are:\n\n",
		myname);
	for (progptr = programs; progptr->name != NULLCP; progptr++)
	    fprintf (stderr,"    %s\n", progptr->name);
	exitcode = 1;
    }

    exit (exitcode);
}
