
## In order to build and install the system you MUST set appropriate 
## values for:
## 
##	MOSS-root
##	LIBDIR
## 	CRYPTOLIBS
##	OSFLAGS
##	BINDIR
##      MANDIR
##
## All directory names must containing a trailing path separator
## (/ for UNIX), e.g., /usr/local/bin/.

## Uncomment the following line for DOS
##
#.SUFFIXES:      .exe .obj .c .asm .h


## Set the value of MOSS-root to the rooted path to the MOSS directory
## within the distribution (the directory containing this file).
## 
MOSS-root 	= /usr/local/src/moss-7.1/moss/


## If necessary, set the value of LIBDIR to the rooted pathname of the
## directory containing the MOSS libraries.  Normally, this would be:
## 
##	$(MOSS-root)lib/
## 
LIBDIR		= $(MOSS-root)lib/


## Set the value of CRYPTOLIBS to the location and name of the library
## containing the crypto-engine necessary to support the algorithms
## configured for use.
## 
## Normally, this is set to the location of rsaref.a.  If you place a
## copy of rsaref.a in the MOSS library directory the default setting is
## correct.
## 
CRYPTOLIBS	= $(LIBDIR)rsaref$(LIBEXT)


## Set the value of OSFLAGS to include a -D with an item chosen from the 
## following list, all of which are mutually exclusive (e.g., -DSYS5).  
## If your OS is not included in this list, try something that is close.
## 
## 		BSD42	BSD43
## 		MACH		-- MOSS assumes this when on NeXT machines
## 		NeXT		-- this is pre-defined on NeXT machines
## 		SUNOS3	SUNOS4
## 		SYS5
## 
## The RSAREF package assumes it is being compiled with a compiler that
## prefers ANSI-style prototype declarations.  As a result, the include
## files that TIS/MOSS has copied from RSAREF have a dependency on the
## setting of the macro PROTOTYPES.  If your compiler does not
## understand prototype declarations you will need to set PROTOTYPES to
## 0, as it is done in the SUN4FLAGS and SUN3FLAGS below.
## 
## Be sure to use the compiler macro definition syntax to specify the
## appropriate operating system value, i.e., -Dvalue.
## 
## We've had good luck with some of the following sets of options and
## others have reported good luck with others.  If one of the following
## macros is appropriate for your environment, it can be used instead of
## specifying the the options individually.  E.g., On a Sun SPARC, set
## OSFLAGS = $(SUN4FLAGS) instead of setting OSFLAGS = -DSUNOS4
## -DPROTOTYPES=0.
##
AIXFLAGS	= -DSYS5 -DPROTOTYPES=0
BSDI486FLAGS	= -DSYS5
DOSFLAGS        = /AL -DDOS
HPUXFLAGS 	= -DSYS5 -DPROTOTYPES=0
NEXTFLAGS	= -bsd 
SGIFLAGS	= -cckr -DSYS5 -DPROTOTYPES=0
SOLARISFLAGS	= -DSYS5 -DPROTOTYPES=0
SUN3FLAGS	= -DSUNOS3 -DPROTOTYPES=0
SUN4FLAGS	= -DSUNOS4 -DPROTOTYPES=0
TXFLAGS		= -M2le -DSYS5 -DPROTOTYPES=0
ULTRIXMIPSFLAGS	= -G 4 -Olimit 1400

OSFLAGS		= 


## Set the value of BINDIR to the name of the directory in which you
## want the TIS/MOSS binaries to be installed.
## 
BINDIR		= /usr/local/bin/


## Set the value of BINPERMS to the octal permission string you would 
## like placed on each of the installed executables.
##
BINPERMS	= 0755


## All values below this point, except the depend target included last,
## rarely need changes.  You may check them to be sure or you can trust
## us.

## If necessary, change the value of MANDIR.
## 
MANDIR		= /usr/man/


## And the directories and extensions of the man pages.
##
DIR1		= manl/
EXT1		= .l
DIR5		= manl/
EXT5		= .l
DIR8		= manl/
EXT8		= .l

## And the permissions on the man pages.
##
MANPERMS	= 0644

## And the path to the catman command (nothing is ok) which is run after 
## the man pages are copied to update the whatis database (catman -w).
##
##CATMAN		= /usr/etc/catman
##CATMAN		= /etc/catman


## If necessary, set the value of INCDIR to the rooted pathname of the
## directory containing the MOSS include files.  Normally this would be:
## 
##	$(MOSS-root)h
## 
INCDIR		= $(MOSS-root)h

## File name extensions
##
OBJEXT		= .o
LIBEXT		= .a
LINTEXT		= .ln
EXEEXT		=

## Compiler and compiler options (CC, OPTIONS)
##
## OPTIONS is provided as a convenient means of indicating those command
## line arguments that can be processed by both CC and LINT.
##
CC		= cc
OPTIONS		= -I$(INCDIR) 


## Setting CFLAGS (OPTIONS, LOPTIONS, OSFLAGS, MOPTIONS)
## 
## Should not need to be tailored, unless you need to remove
## optimization (-O) and perhaps add debugging information (-g).
## 
## OPTIONS and OSFLAGS are described above.
##
## LOPTIONS may be set by a makefile in a subdirectory that requires a
## special option during compilation and/or linting.
##
## MOPTIONS is intended to be used on the make command line as a
## convenient way to change compilation and linting options during
## development.
## 
CFLAGS		= -O $(OPTIONS) $(LOPTIONS) $(OSFLAGS) $(MOPTIONS)


## Loader, loader options and loader libraries (LD, LDOPTIONS, LDLIBS)
##
##	LDOPTIONS are inserted on the loader command line immediately
##	after the ld command and before object files.
##
##	LDLIBS are appended to the end of the loader command line
##	immediately after the object files.
##
##	On TXENIX, use the following macro definitions:
##		LD	  = ld
##		LDOPTIONS = -Ml -S 1024
##		LDLIBS	  = /lib/Llibc.a /lib/Lcrt0.o /lib/Lseg.o /lib/Llibx.a
##
##	On UTS, use the following macro definitions:
##		LD	  = cc
##		LDOPTIONS =
##		LDLIBS	  = /usr/lib/liba.a /usr/lib/libbsd.a \
##			    /usr/lib/libsocket.a
##
##    	On DOS, use the following:
##		LDOPTIONS       = /MAP/SEG:300/ST:15000/NOE

## 
## 	If you set CC above to "gcc", you will need to set LD to "gcc".
## 	In all other cases, the default should suffice.
## 
LD		= $(CC)
LDOPTIONS	=
LDLIBS		= 


## Setting LDFLAGS
## 
## Should not need to be tailored.
##
## LDOPTIONS is described above.
## 
## LLDOPTIONS may be set by a makefile in a subdirectory that requires a
## special option during linking and/or loading.
## 
LDFLAGS 	= $(LDOPTIONS) $(LLDOPTIONS)


## If necessary, set the values of RANLIB and AR.
## Under DOS, set
##	RANLIB          = echo
RANLIB		= ranlib
AR		= ar


## LINT FLAGS (LFLAGS)
## 
##	a - assignments of long to non-long
##	b - report unreachable break statements
##	c - complain about questionable casts
##	h - heuristics to intuit bugs, improve style and reduce waste
##	i - produce .ln file for every .c file
##	n - do not check against standard library
##	u - use on subset of program
##	x - report variables referred to by extern but not used
##	C - create llib-lLIBRARY.ln, -CLIBRARY
##	l - use /usr/lib/lint/llib-lLIBRARY.ln, -lLIBRARY
##	o - name the output file, -o FILE
## SYSTEM V
##	reverse sense of a, b, h and x
##	c is defined as in i above
##	i is not available
##	C is not available, use -o or -c
##	c - produce .ln file for every .c file
##	p - check portability to other C dialects, including truncating all
##		non-external names to 8 characters and externals to 6
##	o - create llib-lLIBRARY.ln, -o LIBRARY
## 
## Should not need to be tailored.
##
## OPTIONS, LOPTIONS, OSFLAGS, and MOPTIONS are described above.
##
## LLOPTIONS may be set by a makefile in a subdirectory that requires a
## special option during linting.
## 
LFLAGS		= -abhx $(LLOPTIONS) \
		  $(OPTIONS) $(LOPTIONS) $(OSFLAGS) $(MOPTIONS)

## Crypto lint libraries (CRYPTOLLIBS)
## 
## Should be tailored to specify the location and name of the lint
## library containing the lint information for the crypto-engine used to
## support the algorithms configured for use.
## 
## Normally, this is set to the location of llib-lrsaref.ln.  If you
## place a copy of llib-lrsaref.ln in the MOSS library directory the
## default setting is correct.
##
CRYPTOLLIBS	= $(LIBDIR)llib-lrsaref.ln


## MUST NOT BE TAILORED
##
## This specifies the correct order of linking the TIS/MOSS libraries.
## 

LIBS1	= $(LIBDIR)libparse$(LIBEXT) $(LIBDIR)libmoss$(LIBEXT) 
LIBS2	= $(LIBDIR)libdata$(LIBEXT) $(LIBDIR)libcert$(LIBEXT) 
LIBS3	= $(LIBDIR)libcrl$(LIBEXT) $(LIBDIR)libcrypto$(LIBEXT) 
LIBS4	= $(LIBDIR)libcbio$(LIBEXT) $(LIBDIR)libdname$(LIBEXT)
LIBS5	= $(LIBDIR)libasn1$(LIBEXT) $(LIBDIR)libutil$(LIBEXT) $(CRYPTOLIBS) 

LIBS	= $(LIBS1) $(LIBS2) $(LIBS3) $(LIBS4) $(LIBS5)

## Should not need to be tailored.
## 
LLIBS	= $(LIBDIR)llib-lasn1$(LINTEXT) $(LIBDIR)llib-lcbio$(LINTEXT) \
	$(LIBDIR)llib-lcert$(LINTEXT) $(LIBDIR)llib-lcrl$(LINTEXT) \
	$(LIBDIR)llib-lcrypto$(LINTEXT) $(LIBDIR)llib-ldata$(LINTEXT) \
	$(LIBDIR)llib-ldname$(LINTEXT) $(LIBDIR)llib-lparse$(LINTEXT) \
	$(LIBDIR)llib-lutil$(LINTEXT) $(CRYPTOLLIBS)

## Some makes use the value of $SHELL, not /bin/sh.

SHELL 		= /bin/sh

## The following are the targets common to all directories.  None of
## them should need to be changed.

default:	real-default

clean:
		-rm -f *$(OBJEXT) $(TARGET) core \
			y.output y.tab.c y.tab.h lex.yy.c \
			$(LIBDIR)$(TARGET) $(LIBDIR)$(LTARGET)

distribution:	clean
		-rm -f *.bak *~ #*

lint:
		lint $(LFLAGS) $(SRC) $(LLIBS)

lint-lib:
		lint $(LLIB) $(LFLAGS) $(SRC)
		mv $(LTARGET) $(LIBDIR)$(LTARGET)

print:
		lpr -p makefile.pre makefile.suf $(INC) $(SRC)



#  CHOOSING A 'make DEPEND' TO GENERATE INCLUDE DEPENDENCIES
#
#  Dependencies are included with the distribution, so this step should 
#  not be necessary.
#
#  Three versions are supplied.  One for sites with cc -M (this is cc -Em
#  on some systems), one for sites without it but with reasonable cc -E
#  output and one for those that don't have either.  Comment out the ones
#  you do not want.
#
#  Note the #include syntax rules that apply to all:
#	1.  standard location files are indicated with <FILE.h>
#	2.  current directory files are indicated with "./FILE.h"
#	3.  INCDIR files are indicated with "FILE.h"
#	4.  all other files must have rooted paths: "/...FILE.h"

## This one is for sites without cc -M and cc -E
#
#  IF YOU USE THIS OPTION, SOME INAPPROPRIATE DEPENDENCIES WILL BE
#  GENERATED.  This is because the "grep" for "include" lines can not take
#  into account "include" lines that are dependent on certain options being
#  set or unset, ie conditionally included.  You will discover these as
#  "make" errors the first time you build the system after doing the "make
#  depend".  The "make" error will indicate that "make" "does not know how
#  to make FILE", where FILE is the inappropriate dependency.  The
#  appropriate source file should be checked to verify that FILE is
#  conditionally included and, if FILE is not intended to exist, the
#  makefile.dep should be edited to remove the dependency.
#
#depend: $(SRC)
#	for i in $(SRC) ; do \
#		(echo $$i: $$i | sed -e 's,c:,o:,' >>makedep; \
#		/bin/grep '^#[ 	]*include[  ]*\"' /dev/null $$i | sed \
#			-e 's,c:[^"]*"\./\([^"]*\)".*,o: \1,' \
#			-e 's,c:[^"]*"/\([^"]*\)".*,o: /\1,' \
#			-e 's,c:[^"]*"\([^"]*\)".*,o: $$(INCDIR)/\1,' \
#			>>makedep); done
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
#	echo '$$r makedep' >>eddep
#	echo 'w' >>eddep
#	rm -f makefile.dep.bak
#	cp makefile.dep makefile.dep.bak
#	rm -f makefile.dep
#	cp makefile.dep.bak makefile.dep
#	ed - makefile.dep < eddep
#	rm eddep makedep makefile.dep.bak
#	echo '' >> makefile.dep
#	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> makefile.dep
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> makefile.dep
#	echo '# see "make depend" for details' >> makefile.dep

## This one is for sites without cc -M but with reasonable cc -E output
## Use this one for TXENIX machines
#
#  You MUST edit the SECOND "sed" command according to your preprocessor
#  output!  Some known possibilities are to change "#line" to be either
#  "#" or "# line".
#
#depend: $(SRC)
#	for i in $(SRC) ; do \
#		(echo $$i: $$i | sed -e 's,c:,o:,' >> makedep; \
#		cc -E $(CFLAGS) $$i | \
#		grep '^#line' | sort -u +2 -3 | \
#		sed -e 's/#line [0-9]* \(.*\)/'$$i': #include \1/p' | \
#		sed -e 's,c:[^"]*"\([^"]*\)".*,o: \1,' | \
#	        egrep '($(INCDIR))|(.*\.c)|(\.\/.*\.h)' | \
#		sed -w 's,$(INCDIR),$$(INCDIR),' \
#		>>makedep); done
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
#	echo '$$r makedep' >>eddep
#	echo 'w' >>eddep
#	rm -f makefile.dep.bak
#	cp makefile.dep makefile.dep.bak
#	rm -f makefile.dep
#	cp makefile.dep.bak makefile.dep
#	ed - makefile.dep < eddep
#	rm eddep makedep makefile.dep.bak
#	echo '' >> makefile.dep
#	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> makefile.dep
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> makefile.dep
#	echo '# see "make depend" for details' >> makefile.dep

## This one is for sites with cc -M
#
depend: $(SRC)
	( for i in $(SRC) ; do \
		${CC} -M $(CFLAGS) $$i ; done ) | \
	egrep '($(INCDIR))|(.*\.c)|(\.\/.*\.h)' |\
	sed -e 's,$(INCDIR),$$(INCDIR),' | \
	awk ' { if ($$1 != prev) { print rec; rec = $$0; prev = $$1; } \
		else { if (length(rec $$2) > 78) { print rec; rec = $$0; } \
		       else rec = rec " " $$2 } } \
	      END { print rec } ' > makedep
	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
	echo '$$r makedep' >>eddep
	echo 'w' >>eddep
	rm -f makefile.dep.bak
	cp makefile.dep makefile.dep.bak
	rm -f makefile.dep
	cp makefile.dep.bak makefile.dep
	ed - makefile.dep < eddep
	rm eddep makedep makefile.dep.bak
	echo '' >> makefile.dep
	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> makefile.dep
	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> makefile.dep
	echo '# see "make depend" for details' >> makefile.dep
