/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

moss_logout(user, iocbs)
char            **user;
struct cbstruct  *iocbs;
{
    char        **pkey = NULLVP;
    int           ret = NOTOK,
                  rfd = -1,
                  wfd = -1;
    char         *pwfile = NULLCP,
                 *cp = NULLCP;
    struct bbuf  *t_pw = NULLBB,
                 *t_pkey = NULLBB,
                 *t_disp = NULLBB;

    /* get public key */

    if (user != NULLVP && (pkey = tag_user(user, "public-key")) == NULLVP) {
	cp2cb(iocbs->out_errs, "Missing public-key for user.\n");
	return NOTOK;
    }

    pwfile = pw_file();
    if (filchk(pwfile, -1, 0) != OK) {
	cp2cb(iocbs->out_user, "No users requiring logout.\n");
	ret = OK;
	goto cleanup;
    }

    if (user == NULLVP)
	if (unlink(pwfile)) {
            cp2cb(iocbs->out_errs,
                  "Unable to unlink login status file.\n");
            goto cleanup;
        }
	else {
	    cp2cb(iocbs->out_user, "All users logged out.\n");
	    ret = OK;
	    goto cleanup;
	}

    if ((rfd = open(pwfile, O_RDONLY)) < 0) {
	cp2cb(iocbs->out_errs, "Unable to read login status file.\n");
	goto cleanup;
    }
    if (unlink(pwfile)) {
	cp2cb(iocbs->out_errs, "Unable to unlink login status file.\n");
	goto cleanup;
    }
    if (filchk(pwfile, 0600, 1) != OK) {
        cp2cb(iocbs->out_errs,"Bad owner/permissions on login status file.\n");
        goto cleanup;
    }
    if ((wfd = lk_open(pwfile, O_WRONLY)) < 0) {
        cp2cb(iocbs->out_errs, "Unable to write login status file.\n");
        goto cleanup;
    }
    if (fdchk(wfd, 0600) != OK) {
        cp2cb(iocbs->out_errs,"Bad owner/permissions on login status file.\n");
        goto cleanup;
    }

    while (read_pwrec(rfd, &t_pw, &t_pkey, &t_disp) == OK) 
	if (!strcmp(*(pkey+1), (char *)(t_pkey->data))) {
	    cp = add2cp(cp, "Logout for ");
	    cp = add2cp(cp, (char *)t_disp->data);
	    cp = add2cp(cp, " complete.\n"); 
	    cp2cb(iocbs->out_user, cp);
	    FREE(cp);
	}
	else
	    (void) write_pwrec(wfd, t_pw, t_pkey, t_disp);

    ret = OK;

 cleanup:

    FREE(pwfile);

    FREE_BBUF(t_pw);
    FREE_BBUF(t_pkey);
    FREE_BBUF(t_disp);

    if (rfd != -1)
	(void) close(rfd);

    if (wfd != -1)
	(void) lk_close(wfd);

    return(ret);
}
