/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

int moss_getkey(user, privkey, iocbs)
char **user;
struct bbuf **privkey;
struct cbstruct *iocbs;

{
    struct bbuf *tmpkey = NULLBB;
    struct bbuf *pw = NULLBB;
    int tries = 0;
    int r;

    if (user == NULLVP) 
	return NOTOK; 	 

pwagain: 

    switch (r = get_key(user, pw, &tmpkey)) {
    case OK:

        /* great, no problems */

	if (tmpkey != NULLBB) {
	    FREE_BBUF (*privkey);
	    *privkey = tmpkey;
	    tmpkey = NULLBB;
	}
	else
	    FREE_BBUF(tmpkey);

        break;

    case EINVAL:

        /* incorrect password */

	if (iocbs == NULL_IOCBS || iocbs->out_user == NULL_OUTCB ||
	    iocbs->ne_user == NULL_INCB)
	    goto cleanup;

        if (pw != NULLBB) {
            FREE_BBUF(pw);
	    if (++tries < MAXPWTRIES)
		cp2cb(iocbs->out_user, "\nIncorrect password.  Try again.\n");
	    else {
		cp2cb(iocbs->out_user, "\nMaximum tries exceeded.\n");
		goto cleanup;
	    }
        }

        /* okay, we need password; can we get it? */

        if ((pw = get_password(iocbs, 0)) == NULLBB)
            goto cleanup;
        goto pwagain;

    case NOTOK:

        /* who knows; the originator loses */

	if (iocbs != NULL_IOCBS)
	    cp2cb(iocbs->out_errs, "Unable to access private key.\n");
        goto cleanup;
    }

 cleanup:

    FREE_BBUF(pw);
    return r;
}
