/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "cert.h"
#include "crl.h"
#include "crypto.h"
#include "dname.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

moss_crl(issuser, revusers, iocbs)
char ***issuser;
struct user_list *revusers;
struct cbstruct *iocbs;
{
    int   ret = NOTOK;
    struct bbuf *newcrl = NULLBB;
    struct bbuf *oldcrl = NULLBB;
    struct bbuf *cert = NULLBB;
    struct bbuf *serial = NULLBB;
    struct bbuf *issuer = NULLBB;
    struct bbuf *realissuer = NULLBB;
    struct bbuf *mic = NULLBB;
    struct bbuf *emic = NULLBB;
    struct bbuf *smic = NULLBB;
    struct bbuf *privkey = NULLBB;
    struct bbuf *etbs = NULLBB;
    struct bbuf *crltext = NULLBB;
    struct bbuf bb;
    struct rcl_entry *newrcl = NULL_RCL_ENTRY;
    struct rcl_entry *oldrcl = NULL_RCL_ENTRY;
    struct rcl_entry *rcl = NULL_RCL_ENTRY;
    struct rcl_entry *entry = NULL_RCL_ENTRY;
    struct algent *mic_ae = NULL_ALGENT;
    struct algid *mic_aid = NULL_ALGID;
    struct algid *sig_aid = NULL_ALGID;
    struct user_list *revuser = NULLUL;
    struct crltobesigned *tbs = NULL_CRLTOBESIGNED;
    char **av = NULLVP;
    char *cp = NULLCP;
    char *cptmp = NULLCP;
    long now = TIME();
    long revtime;
    long begin;
    long end;
    long valid = 0L;
    int expired;

    /* Check args */

    if (iocbs == NULL_IOCBS)
        goto cleanup;
    if (issuser == (char ***)0 || *issuser == NULLVP) {
	cp2cb(iocbs->out_errs, "A non-null issuer is required.\n");
	goto cleanup;
    }

    /* Make sure we have a valid crl-period */

    if ((av = tag_user(user_tailor, "crl-period")) != NULLVP)
	valid = str2valid(*(av+1));
    if (valid == 0L) {
	cp2cb(iocbs->out_errs, "A non-zero crl-period is required.\n");
	goto cleanup;
    }

    /* Get subject name (issuer name for revoked certificates) */

    if ((av = tag_user(*issuser, "subject-name")) != NULLVP) { 	
	if ((issuer = str2dn(*(av+1))) == NULLBB) { 	
	    cp2cb(iocbs->out_errs, 
		  "Unable parse issuer's distinguished name.\n"); 
	    goto cleanup; 	
	} 
    }
    else {
	cp2cb(iocbs->out_errs, "Issuer does not have subject-name.\n");
	goto cleanup;
    }

    /* Look for old CRL */

    if ((av = tag_user(*issuser, "crl")) != NULLVP) {
	cp = add2cp(NULLCP, "Updating CRL for issuing ");
	bb.data = (unsigned char *) *(av+1);
	bb.length = strlen(*(av+1));
	if (bdecode(&bb, &oldcrl) != OK) {
	    cp2cb(iocbs->out_errs, "Unable to decode old CRL.\n");
	    goto cleanup;
	}
    }
    else {
	cp = add2cp(NULLCP, "Creating new CRL for issuing ");
	oldcrl = alloc_bbuf();
    }
    cptmp = pretty_user(*issuser);
    cp = add2cp(cp, cptmp);
    cp = add2cp(cp, "...\n");
    cp2cb(iocbs->out_user, cp);
    FREE(cp);
    FREE(cptmp);

    /* Retrieve RCL from old CRL */

    if (rcl_crl(&oldcrl, &oldrcl, READ) != OK) {
	cp2cb(iocbs->out_errs, "Unable to read RCL from old CRL.\n");
	goto cleanup;
    }

    /* Allocate the new CRL */

    newcrl = alloc_bbuf();

    /* make sure issuer name is DER and insert into CRL */

    if ((realissuer = der_dn(issuer)) == NULLBB) {
	cp2cb(iocbs->out_errs, "Unable to DER encode issuer name.\n");
	goto cleanup;
    }
    FREE_BBUF(issuer);
    if (issuer_crl(&newcrl, &realissuer, WRITE) != OK) {
        cp2cb(iocbs->out_errs, "Unable to write issuer name to CRL.\n");
        goto cleanup;
    }

    /* Update valid period */

    begin = now;
    end = begin + valid;
    
    if (period_crl(&newcrl, &begin, &end, WRITE) != OK) {
	cp2cb(iocbs->out_errs, "Unable to update validity period.\n");
	goto cleanup;
    }

    /* Loop through supplied list of revoked users */

    for (revuser = revusers; revuser != NULLUL; revuser = revuser->next) {

	/* Identify the user record being processed */

	cp = add2cp(NULLCP, "Processing revoked ");
	cptmp = pretty_user(revuser->user);
	cp = add2cp(cp, cptmp);
	cp = add2cp(cp, "...\n");
	cp2cb(iocbs->out_user, cp);
	FREE(cp);
	FREE(cptmp);
	
	/* Check for certificate and valid period */

	if ((av = tag_user(revuser->user, "certificate")) == NULLVP) 
	    expired = 0;
	else
	{
	    bb.data = (unsigned char *) *(av+1);
	    bb.length = strlen(*(av+1));
	    if (bdecode(&bb, &cert) != OK) {
		cp2cb(iocbs->out_errs, 
		      "Unable to decode revoked user's certificate.\n");
		goto cleanup;
	    }
	    if (valid_cert(&cert, &begin, &end, READ) != OK) {
		cp2cb(iocbs->out_errs,
                      "Unable read valid period from user's certificate.\n");
                goto cleanup;
	    }
	    expired = now > end;
	}

	/* Get and check issuer name */

	if ((av = tag_user(revuser->user, "issuer-name")) != NULLVP)
	    issuer = str2dn(*(av+1));
	else if (cert != NULLBB) {
	    if (issuer_cert(&cert, &issuer, READ) != OK) {
		cp2cb(iocbs->out_errs,
		      "Unable to read issuer name from user's certificate.\n");
		goto cleanup;
	    }
	}
	else {
	    cp2cb(iocbs->out_errs,
	     "Revoked user contains neither issuer-name nor certificate.\n");
	    goto cleanup;
	}
	if (dncmp(issuer, realissuer) != 0) {
	    cp2cb(iocbs->out_errs, "Issuer name mismatch.\n");
	    goto cleanup;
	}
	
	/* Get serial number */

	if ((av = tag_user(revuser->user, "serial-number")) != NULLVP) 
	    serial = hex2bin(*(av+1));
	else if (cert != NULLBB) {
	    if (serial_cert(&cert, &serial, READ) != OK) {
		cp2cb(iocbs->out_errs,
		 "Unable to read serial number from user's certificate.\n");
		goto cleanup;
	    }
	}
	else {
	    cp2cb(iocbs->out_errs,
   	     "Revoked user contains neither serial-number nor certificate.\n");
	    goto cleanup;
	}

	/* Display serial number */

	cp = add2cp(NULLCP, "    Serial number for this user is ");
	cptmp = bin2hex(serial->data, serial->length);
	cp = add2cp(cp, cptmp);
	cp = add2cp(cp, ".\n");
	cp2cb(iocbs->out_user, cp);
	FREE(cp);
	FREE(cptmp);

	/* Set revocation time (see if serial number is on old CRL */

	revtime = now;
	_rclinit(&oldrcl);
	for (rcl=_rclfirst(oldrcl);rcl!=NULL_RCL_ENTRY;rcl=_rclnext(oldrcl)) {
	    if (!bbufcmp(rcl->serial, serial)) {
		revtime = rcl->date;
		cp2cb(iocbs->out_user, "    This user was on the old CRL.\n");
		_rcldelete(oldrcl);
		break;
	    }
	}
	_rclend(&oldrcl);

	/* Place serial number on new CRL if cert hasn't expired */
	
	if (expired) {
	    cp2cb(iocbs->out_user, 
	      "    This user's certificate has expired -- leaving off CRL.\n");
	}
	else {

	    /* Make sure serial number isn't already on new CRL */

	    _rclinit(&newrcl);
	    for(rcl = _rclfirst(newrcl);
		rcl != NULL_RCL_ENTRY;
		rcl = _rclnext(newrcl))
		if (!bbufcmp(serial, rcl->serial))
		    break;

	    /* Already on CRL! */

	    if (rcl != NULL_RCL_ENTRY) 
		cp2cb(iocbs->out_user,
	        "    This user's serial number is already on the new CRL.\n"); 

	    /* Not on CRL -- add it */

	    else {
		cp2cb(iocbs->out_user, 
		      "    Placing this user on the new CRL.\n");
		entry = alloc_rcl_entry();
		entry->date = revtime;
		entry->serial = serial;
		serial = NULLBB;
		_rclappend(newrcl, entry);
	    }
	    _rclend(&newrcl);
	}
	
	FREE_BBUF(cert);
	FREE_BBUF(issuer);
	FREE_BBUF(serial);
    }

    /* Report on serial numbers on old CRL but not listed */

    _rclinit(&oldrcl);
    for (rcl=_rclfirst(oldrcl);rcl!=NULL_RCL_ENTRY;rcl=_rclnext(oldrcl)) {
	cp = add2cp(NULLCP, "Serial number ");
	cptmp = bin2hex(rcl->serial->data, rcl->serial->length);
	cp = add2cp(cp, cptmp);
	cp = add2cp(cp, 
	     " was on the old CRL but not included in the list to revoke.\n");
	cp2cb(iocbs->out_user, cp);
	FREE(cp);
	FREE(cptmp);
    }
    _rclend(&oldrcl);

    /* Write new RCL to new CRL */

    if (rcl_crl(&newcrl, &newrcl, WRITE) != OK) {
	cp2cb(iocbs->out_errs, "Unable write RCL to new CRL.\n");
	goto cleanup;
    }

    /* get the private key */

    if (moss_getkey(*issuser, &privkey, iocbs) != OK)
	goto cleanup;

    /* Generate signature */

    cp2cb(iocbs->out_user, "Signing the CRL...\n");

    /* Get hash algorithm */

    if ((av = tag_user(user_tailor, "mic-alg")) == NULLVP) {
        (void) cp2cb(iocbs->out_errs, "Unable to determine mic-alg.\n");
        goto cleanup;
    }

    if ((mic_ae = getalgstr(algorithms, *(av+1), MIC)) == NULL_ALGENT) {
        cp = add2cp(NULLCP, "mic-alg contains an invalid algorithm \"");
        cp = add2cp(cp, *(av+1));
        cp = add2cp(cp, "\".\n");
        (void) cp2cb(iocbs->out_errs, cp);
        FREE(cp);
        goto cleanup;
    }

    mic_aid = alloc_algid();
    mic_aid->alg =  mic_ae->code;

    /* Read signature alg from private key and write to CRL */

    if (algid_key(&privkey, &sig_aid, READ) != OK) {
        cp2cb(iocbs->out_errs, "Unable to dertermine signature algid.\n");
        goto cleanup;
    }

    if (sig_alg_crl(&newcrl, &sig_aid, INNER|OUTER, WRITE) != OK) {
        cp2cb(iocbs->out_errs, "Unable to write algid to CRL.\n");
        goto cleanup;
    }

    /* Sign TBS */

    if (tobesigned_crl(&newcrl, &tbs, READ) != OK) {
        cp2cb(iocbs->out_errs, "Unable to extract tobesigned from CRL.\n");
        goto cleanup;
    }

    if (encode_rtbs(tbs, &etbs) != OK) {
	cp2cb(iocbs->out_errs, "Unable to encode tobesigned from CRL.\n");
        goto cleanup;
    }

    if (gen_mic(mic_aid->alg, NULLBB, etbs, &mic) != OK) {
	cp2cb(iocbs->out_errs, "Unable to generate MIC.\n");
        goto cleanup;
    }

    if (encode_mic(mic, mic_aid, &emic) != OK) {
	cp2cb(iocbs->out_errs, "Unable to encode MIC.\n");
        goto cleanup;
    }
    
    if (set_key(privkey) != OK) {
        cp2cb(iocbs->out_errs, "Unable to use issuer's private key.\n");
        goto cleanup;
    }

    if (sign(emic, &smic) != OK) {
        cp2cb(iocbs->out_errs, "Unable to generate signature.\n");
        goto cleanup;
    }

    /* Place signature in CRL */

    if (sig_crl(&newcrl, &(smic->data), &(smic->length), WRITE) != OK) {
        cp2cb(iocbs->out_errs, "Unable to update CRL with signature.\n");
        goto cleanup;
    }

    /* Printably encode the CRL */

    bencode(newcrl, &crltext);

    /* Place CRL in issuer's user record */

    if ((av = tag_user(*issuser, "crl")) == NULLVP) {
	*issuser = add2av(*issuser, add2cp(NULLCP, "crl"));
	*issuser = add2av(*issuser, (char *)crltext->data);
    }
    else {
	FREE(*(av+1));
	*(av+1) = (char *) crltext->data;
    }
    crltext->data = NULLUCP;
    
    /* That's all */

    ret = OK;

 cleanup:

    FREE_BBUF(oldcrl);
    FREE_BBUF(newcrl);
    FREE_BBUF(etbs);
    FREE_BBUF(mic);
    FREE_BBUF(emic);
    FREE_BBUF(smic);
    FREE_BBUF(privkey);
    FREE_BBUF(crltext);
    FREE_ALGID(mic_aid);
    FREE_ALGID(sig_aid);

    return ret;
}
