/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include <stdio.h>

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

#define indent(_string_, _level_) {\
		int _i_;\
		for (_i_=0; _i_<_level_; _i_++)\
			_string_= add2cp(_string_, "    ");\
		}

static char *_disp_asn_tag();
static int _disp_asn();

int disp_asn(bbuf, out)
struct bbuf *bbuf;
char	    ***out;
{

    if (bbuf == (struct bbuf *)0 || out == (char ***)0)
        return(NOTOK);

    return(_disp_asn(bbuf, out, 0));
}


static _disp_asn(bbuf, out, level)
struct bbuf *bbuf;
char ***out;
int level;
{
    struct bbuf *bb, *sub_bbuf= NULLBB, *list= NULLBB;
    OID oid= NULLOID;
    struct algent *entry= NULL_ALGENT;
    int j, pos= 0, ret= OK, dummy;
    long utct;
    unsigned char tag;
    char *str= NULLCP, *tmp=NULLCP;

    if ((tag=asn_extract(bbuf, &sub_bbuf, &pos)) == PARSE_ERROR
	|| asn_parse(bbuf, &list) != OK) {
        indent(str, level);
        str = add2cp(str, "MALFORMED INPUT");
	goto cleanup;
    }
    
    /*print the tag */
    indent(str, level);
    str = add2cp(str, "tag: ");
    str = add2cp(str, _disp_asn_tag(tag));

    /* print length */
    str = add2cp(str, "\tlength: ");
    str = addint2cp(str, pos);
    *out = add2av(*out, str);
    str = NULLCP;
    
    for (bb=list; bb!=NULLBB; bb=bb->next) {
	switch(tag&FORM_MASK) {
	case FORM_CONS:
	    if ((ret = _disp_asn(bb, out, level+1)) != OK)
	        goto cleanup;
	    break;

        case FORM_PRIM:
            /* print data */
            indent(str, level);
            str = add2cp(str, "value: ");
            switch (tag & TAG_MASK) {
            case PRIM_OID:
    	        if (decode_oid(bbuf, &oid, &dummy) != OK) {
                    str = add2cp(str, "UNABLE TO DECODE OID");
                    break;
		}
                str = add2cp(str, sprintoid(oid));
                str = add2cp(str, " (");
		tmp = vallookup(label_attribute,strilookup(oidstr_attribute,
							  sprintoid(oid)));
		if (tmp == NULLCP && 
		    (entry=getalgoid(algorithms, oid, 0)) != NULL_ALGENT)
                    str = add2cp(str, add2cp(NULLCP, entry->str));
		else
                    str = add2cp(str, (tmp==NULLCP) ? "UNKNOWN" : tmp);
                str = add2cp(str, ") ");
                break;

            case PRIM_NULL:
		tmp = add2cp(NULLCP, "(NULL)");
                str = add2cp(str, tmp);
    		FREE(tmp);
		break;

            case DEFN_PRTS:
		tmp = alloc_char(bb->length+1);
	        BCOPY(bb->data, tmp, bb->length);
                str = add2cp(str, tmp);
    		FREE(tmp);
		break;

            case DEFN_T61S:
		if (t612str(bb->data, bb->length, &tmp) != OK)
		    goto cleanup;
                str = add2cp(str, tmp);
    		FREE(tmp);
		break;

            case PRIM_INT:
    	        (void) decode_int(bbuf, &j, &dummy);
	        str = addint2cp(str, j);
		break;

            case DEFN_UTCT:
    	        (void) decode_utct(bbuf, &utct, &dummy);
	        str = add2cp(str, ctime(&utct));
		break;

            default:
	        str = addhex2cp(str, sub_bbuf->data, sub_bbuf->length);
            }

            *out = add2av(*out, str);
            *out = add2av(*out, add2cp(NULLCP, " "));
            str = NULLCP;
	    break;

	default:
	    ret = NOTOK;
	    goto cleanup;
	}
    }

 cleanup:
    FREE_BBUF(sub_bbuf);
    FREE_BBUFS(list);

    return(ret);
}


static char *_disp_asn_tag(tag)
unsigned char tag;
{
    char *ret= NULLCP;

    switch (tag & CLASS_MASK) {
    case CLASS_UNIV:
        ret = add2cp(ret, "CLASS_UNIV"); 
        break;
    default:
        ret = add2cp(ret, "invalid class"); 
    }
    switch (tag & FORM_MASK) {
    case FORM_PRIM:
        ret = add2cp(ret, "|FORM_PRIM"); 
        break;
    case FORM_CONS:
        ret = add2cp(ret, "|FORM_CONS"); 
    }
    switch (tag & TAG_MASK) {
    case PRIM_INT:
        ret = add2cp(ret, "|PRIM_INT"); 
        break;
    case PRIM_BITS:
        ret = add2cp(ret, "|PRIM_BITS"); 
        break;
    case PRIM_OCTS:
        ret = add2cp(ret, "|PRIM_OCTS"); 
        break;
    case PRIM_NULL:
        ret = add2cp(ret, "|PRIM_NULL"); 
        break;
    case PRIM_OID:
        ret = add2cp(ret, "|PRIM_OID"); 
        break;
    case CONS_SEQ:
        ret = add2cp(ret, "|CONS_SEQ"); 
        break;
    case CONS_SET:
        ret = add2cp(ret, "|CONS_SET"); 
        break;
    case DEFN_PRTS:
        ret = add2cp(ret, "|DEFN_PRTS"); 
        break;
    case DEFN_T61S:
        ret = add2cp(ret, "|DEFN_T61S"); 
        break;
    case DEFN_UTCT:
        ret = add2cp(ret, "|DEFN_UTCT"); 
        break;
    default:
        ret = add2cp(ret, "|invalid tag number"); 
        break;
    }
    return(ret);
}
