/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

canon_ava(ava, canonava)
struct bbuf *ava, **canonava;
{
    struct bbuf *val= NULLBB, *canonval= NULLBB;
    OID oid= NULLOID;
    char *davstr= NULLCP;
    long davutct;
    int davint;
    int dummy, retval= NOTOK;

    if (ava == NULLBB) 
        return(NOTOK);

    if (canonava == (struct bbuf **)0) 
        return(NOTOK);

    FREE_BBUF(*canonava);

    if (decode_ava(ava, &oid, &val) != OK) 
	goto cleanup;

    /* Decode value based on oid type */
    switch (strilookup(oidstr_syntax, sprintoid(oid))) {
    case CaseExactString:
    case PrintableString:
	switch CHARSET(val) {
	case DEFN_T61S:
	    if (decode_t61s(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    if (encode_t61s(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	case DEFN_PRTS:
	    if (decode_prts(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    if (encode_prts(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	}
	break;

    case CaseIgnoreString:
    case CaseIgnoreList:
	switch CHARSET(val) {
	case DEFN_T61S:
	    if (decode_t61s(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)strupcase(davstr);
	    if (encode_t61s(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	case DEFN_PRTS:
	    if (decode_prts(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)strupcase(davstr);
	    if (encode_prts(davstr, &canonval) != OK)
	        goto cleanup;
	}
	break;

    case NumericString:
	switch CHARSET(val) {
	case DEFN_T61S:
	    if (decode_t61s(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)del_str(davstr,' ');
	    if (encode_t61s(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	case DEFN_PRTS:
	    if (decode_prts(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)del_str(davstr,' ');
	    if (encode_prts(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	}
	break;

    case Boolean:
    case Integer:
	if (decode_int(val, &davint, &dummy) != OK)
	    goto cleanup;
	if (encode_int(davint, &canonval) != OK)
	    goto cleanup;
	break;

    case PhoneNumber:
	switch CHARSET(val) {
	case DEFN_T61S:
	    if (decode_t61s(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)del_str(davstr,' ');
	    (void)del_str(davstr,'-');
	    if (encode_t61s(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	case DEFN_PRTS:
	    if (decode_prts(val, &davstr, &dummy) != OK)
	        goto cleanup;
	    (void)trim_whitesp(davstr);
	    (void)del_str(davstr,' ');
	    (void)del_str(davstr,'-');
	    if (encode_prts(davstr, &canonval) != OK)
	        goto cleanup;
	    break;
	}
	break;

    case UTCTime:
	if (decode_utct(val, &davutct, &dummy) != OK)
	    goto cleanup;
	if (encode_utct(davutct, &canonval) != OK)
	    goto cleanup;
	break;

    case OctetString:
    default:
	if ((canonval=dup_bbuf(val)) == NULLBB)
	    goto cleanup;

	break;
    }

    if (encode_ava(oid, canonval, canonava) != OK)
	goto cleanup;

    retval = OK;

 cleanup:
    FREE_OID(oid);
    FREE(davstr);
    FREE_BBUF(val);
    FREE_BBUF(canonval);
    if (retval != OK)
	FREE_BBUF(*canonava);

    return(retval);
}
