/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "util.h"
#include "x500.h"

ava_sort(ava)
struct bbuf **ava;
{
    struct bbuf *ptr1 = NULLBB, *ptr2 = NULLBB;
    int cmp, swapping = 1;

    if (ava == (struct bbuf **)0) 
        return(NOTOK);

    if ((*ava == NULLBB) || ((*ava)->next == NULLBB))
	return(OK);

    while (swapping) {
	swapping = 0;
        for (ptr1 = *ava; ptr1!=NULLBB && ptr1->next!=NULLBB;
	     ptr1 = ptr1->next)
	    /* Duplicate attributes are illegal */
	    if ((cmp=avacmp(ptr1, ptr1->next)) == 0)
		return(NOTOK);
	    else if (cmp > 0) { /* swap these ava's */
		swapping = 1;
		ptr2 = ptr1->next;
		if (ptr1->prev != NULLBB)
		    ptr1->prev->next = ptr2;
		if (ptr2->next != NULLBB)
		    ptr2->next->prev = ptr1;
		ptr1->next = ptr2->next;
		ptr2->next = ptr1;
		ptr2->prev = ptr1->prev;
		ptr1->prev = ptr2;
	        if (ptr1 == *ava)
	            *ava = ptr2;
	    }
    }

    return(OK);
}
