/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"
#include "new.h"
#include "util.h"

char *qualify_filename(fn, defdir)
char *fn, *defdir;

{
    char *newfn = NULLCP, *tmpfn = NULLCP, *cp;

    if (fn == NULLCP || *fn == NULLC)
	goto cleanup;
    
    tmpfn = add2cp(NULLCP, fn);

    if (*tmpfn != PATH_SEP && defdir != NULLCP && *defdir != NULLC) {
	cp = add2cp(NULLCP, defdir);
	if (cp[strlen(cp)-1] != PATH_SEP)
	    cp = add2cp(cp, PATH_SEP_STRING);
	cp = add2cp(cp, tmpfn);
	FREE(tmpfn);
	tmpfn = cp;
    }

    if (*tmpfn != PATH_SEP) {
	if ((cp = getenv("HOME")) == NULLCP) 
	    goto cleanup;
	cp = add2cp(NULLCP, cp);
	cp = add2cp(cp, PATH_SEP_STRING);
	cp = add2cp(cp, tmpfn);
	FREE(tmpfn);
	tmpfn = cp;
    }

    newfn = tmpfn;
    tmpfn = NULLCP;
    
 cleanup:
    
    FREE(tmpfn);
    return newfn;
}
