/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * initprng.c
 ****************************************************************************/

#include "config.h"
#include <stdio.h>
#ifdef _SYS5_
#include <sys/utsname.h>
#endif /* _SYS5_ */
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "new.h"
#include "util.h"

/****************************************************************************
 * seedbysig()
 ****************************************************************************/

struct bbuf *seedbysig(user) 
char **user;
{
    static int initcount = 0;	/* ensure that seed is different if re-init */

    struct algid *aid = NULL_ALGID;
    struct algent *ae = NULL_ALGENT;
    struct bbuf *newseed  = NULLBB;
    struct bbuf *sigfood  = NULLBB;
    struct bbuf *dfoodmic = NULLBB;
    struct bbuf *efoodmic = NULLBB;
    struct bbuf *privkey  = NULLBB;
    char **av = NULLVP;
    long sigmisc [8];
#ifdef _SYS5_
    struct utsname sighost;
#else
    char sighost [20];
#endif

    if (user == NULLVP)
	goto cleanup;

    /* Generate the seed food.  The combination of seed food must be 
     * unique for the current signature key.
     */

    sigmisc[0] = TIME();
    sigmisc[7] = initcount++;
#ifndef PC
    sigmisc[1] = getpid();
    sigmisc[2] = getppid();
    sigmisc[3] = getuid();
    sigmisc[4] = geteuid();
    sigmisc[5] = getgid();
    sigmisc[6] = getegid();
#ifdef _SYS5_
    (void)uname(&sighost);
#else
    gethostname (sighost, sizeof(sighost));
#endif /* _SYS5_ */
#endif /* !PC */
 
    /* Create the bbuf to be signed */

    sigfood = alloc_bbuf();
    sigfood -> length = sizeof(sigmisc) + sizeof(sighost); 
    sigfood -> data = alloc_uchar(sigfood -> length);

    /*  Place the seed food into the bbuf to be signed */

    BCOPY(sigmisc, sigfood -> data, sizeof(sigmisc));
#ifdef _SYS5_
    BCOPY(&sighost, sigfood -> data + sizeof(sigmisc), sizeof(sighost));
#else
    BCOPY(sighost, sigfood -> data + sizeof(sigmisc), sizeof(sighost));
#endif
    /*  Hash the food first */

    if ((av = tag_user(user_tailor, "hash-alg")) == NULLVP) 
	goto cleanup;

    if ((ae = getalgstr(algorithms, *(av+1), MIC)) == NULL_ALGENT)
	goto cleanup;

    if (gen_mic(ae->code, NULLBB, sigfood, &dfoodmic) != OK)
 	goto cleanup;

    /*  Encode the hashed food */

    aid = alloc_algid();
    aid->alg = ae->code;

    if (encode_mic(dfoodmic, aid, &efoodmic) != OK)
	goto cleanup;

    /* Make sure we have access to the private key */

    if (getalgcode(algorithms, curalg, SIG) == NULL_ALGENT) {

	if (get_key(user, NULLBB, &privkey) != OK)
	    goto cleanup;

	if (!strcasecmp(*(tag_user(user, "private-key-access")+1), "file") &&
	    privkey != NULLBB)
	    if (set_key(privkey) != OK) goto cleanup;
    }

    /* Encrypt the MIC to produce the signature */

    if (sign(efoodmic, &newseed) != OK)
        goto cleanup;

 cleanup:
  
    FREE_ALGID(aid);
    FREE_BBUF(sigfood);
    FREE_BBUF(dfoodmic);
    FREE_BBUF(efoodmic);
    FREE_BBUF(privkey);
 
    return(newseed);
}


/****************************************************************************
 * initprng()
 ****************************************************************************/

int initprng(user)
char **user;
{
    FREE_BBUF(seedbb);

    if (user != NULLVP)
	seedbb = seedbysig(user);
    else
	seedbb = seedbyscript();

    return (seedbb != NULLBB ? OK : NOTOK);
}

