/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * data_key.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "key.h"

data_key(ekey, data, mode)
struct bbuf **ekey, **data;
int mode;
{
    int ret = NOTOK;
    struct key *key= NULL_KEY;

    /* DOUBLE-CHECK PARAMETERS */
    if (ekey == (struct bbuf **)0 || *ekey == NULLBB || 
	data == (struct bbuf **)0) 
	goto cleanup;

    if (decode_key(*ekey, &key) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
        FREE_BBUF(*data);

	if (key->data != NULLBB &&
	    (*data = dup_bbuf(key->data)) == NULLBB)
	    goto cleanup;

	ret = OK;

	break;

    case WRITE:
	FREE_BBUF(key->data);

	if (*data != NULLBB &&
	    (key->data = dup_bbuf(*data)) == NULLBB)
	    goto cleanup;

        ret = encode_key(key, ekey);

	break;

    default:
	goto cleanup;
    }

 cleanup:

    FREE_KEY(key);
    return(ret);
}

