/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 *  cbdeciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "cbio.h"
#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./global.h"
#include "./des.h"

/****************************************************************************/

static int cbdecipher_descbc(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    struct bbuf *key = NULLBB;	/* key */
    struct bbuf *iv = NULLBB;	/* IV */
    int firsttime = 1;
    unsigned char indata[8], outdata[8];
    struct bbuf outbuf;
    DES_CBC_CTX context;

    /* decode key & iv */

    if (decode_deskeydata(curdata, &key) != OK)
        return(NOTOK);
    if (decode_deskeyparms(curparms, &iv) != OK)
        return(NOTOK);

    /* set up key schedule */

    DES_CBCInit(&context, key->data, iv->data, 0 /* decrypt */);
    FREE_BBUF(key);
    FREE_BBUF(iv);

    outbuf.length = 8;
    outbuf.data = outdata;
    while (readblock(incb, 8, indata) == 8) {
	if (!firsttime)
	    (void) outcb(&outbuf);
	firsttime = 0;
        DES_CBCUpdate(&context, outdata, indata, 8);
    }

    if ((outbuf.length = 8 - (int)outdata[7]) > 0)
	(void) outcb(&outbuf);

    return(OK);
}

/*****************************************************************************/

int cbdecipher_des(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    int r;

    /* check arguments */

    if (incb == NULL_INCB || outcb == NULL_OUTCB)
	goto cleanup;

    /* decrypt with specified mode of operation */

    switch(curalg) {
    case DES_CBC:
	if ((r = cbdecipher_descbc(incb, outcb)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    return(r);
}

