/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * adddesparms2cp.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int adddesparms2cp(dek, cpp)
struct key *dek;
char **cpp;
{
    int r, alg;
    struct bbuf *parms;
    struct bbuf *ivbb = NULLBB;

    if (dek == NULL_KEY || cpp == (char **)0 || dek->algid == NULL_ALGID) 
	return(NOTOK);

    alg = dek->algid->alg;

    switch(alg) {
    case DES:
    case DES_CBC:
	if (dek->algid->parms == NULLBB) 
	    return(NOTOK);
	parms = dek->algid->parms;
	if ((r = decode_deskeyparms(parms, &ivbb)) != OK)
	    return(r);
	*cpp = add2cp(*cpp, ",");
	*cpp = addhex2cp(*cpp, ivbb->data, ivbb->length);
	FREE_BBUF(ivbb);
	break;

    case DES_ECB:
    case DES_EDE:
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}


