/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crl.h"
#include "util.h"

issuer_crl(crl, issuer, mode)
struct bbuf **crl;
struct bbuf **issuer;
int mode;
{
    struct crl  *dcrl= NULL_CRL;
    int		ret= NOTOK;

    if (crl == (struct bbuf **)0 || *crl == NULLBB) 
	goto cleanup;

    if (issuer == (struct bbuf **)0) 
	goto cleanup;

    if (decode_crl(*crl, &dcrl) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
	if (dcrl -> tobesigned == NULL_CRLTOBESIGNED) 
	    goto cleanup;

	FREE_BBUF(*issuer);

	if ((dcrl->tobesigned->issuer != NULLBB) &&
	    ((*issuer = dup_bbuf(dcrl->tobesigned->issuer)) == NULLBB))
	    goto cleanup;
	ret = OK;

	break;

    case WRITE:
	if (dcrl->tobesigned == NULL_CRLTOBESIGNED) 
	    dcrl -> tobesigned = alloc_crltobesigned();

	FREE_BBUF(dcrl->tobesigned->issuer);

	if ((*issuer != NULLBB) && 
	    ((dcrl->tobesigned->issuer=dup_bbuf(*issuer)) == NULLBB))
	    goto cleanup;

        ret = encode_crl(dcrl, crl);
	break;

    default:
	goto cleanup;
	/* NOTREACHED */
    }

 cleanup:

    FREE_CRL(dcrl);
    return(ret);
}
