/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "util.h"

#define C_TAG		"tag: "
#define C_LENGTH	"length: "
#define C_DATA		"data: "
#define C_NEXT		"next: "
#define C_PREV		"prev: "
#define C_CHAIN		"chain: "
#define	C_VERSION	"version: "
#define C_SERIAL_NBR	"serial number: "
#define C_ALG_IN	"signature algorithm (inner):"
#define C_ALG_OUT	"signature algorithm (outer):"
#define C_ISSUER_DN	"issuer distinguished name:"
#define C_VALID		"validity period: "
#define CV_BDATE	"    begin: "
#define CV_EDATE	"    end: "
#define C_SUBJECT_DN	"subject distinguished name:"
#define C_SPKI		"subject public key information:"
#define C_SIGNATURE	"signature: "

disp_cert(cert, out)
struct bbuf		*cert;
char			***out;
{
    int version;
    long begin, end;
    char *cp = NULLCP;
    char **tav = NULLVP;
    char *c;
    unsigned char *sig = NULLUCP;
    int slen;
    struct bbuf	*serial = NULLBB;
    struct bbuf	*dname = NULLBB;
    struct algid *aid = NULL_ALGID;
    struct bbuf *spk = NULLBB;

    if (out == (char ***)0)
	return(NOTOK);

    /* check to see that we got a pointer to a cert */
    if (cert == NULLBB) {
	*out = add2av(*out, add2cp(NULLCP, "NULL CERTIFICATE"));
	return(OK);
    }

    /* version field */
    cp = add2cp(cp, C_VERSION);
    if ((version_cert(&cert, &version, READ)) == OK)
	cp = addint2cp(cp, version);
    *out = add2av(*out, cp);
    cp = NULLCP;

    /* inner sig_alg identifier field */
    *out = add2av(*out, add2cp(NULLCP, C_ALG_IN));
    if ((sig_alg_cert(&cert, &aid, INNER, READ)) == OK) {
	(void) disp_algid(aid, &tav);
	prefixav (tav, "    ");
        *out = addav2av(*out, tav);
        FREE_AV(tav);
    }

    /* serial number field */
    cp = add2cp(cp, C_SERIAL_NBR);
    if ((serial_cert(&cert, &serial, READ) == OK)
	&& (serial != NULLBB)) {
	cp = add2cp(cp, "0x");
	cp = addhex2cp(cp, serial->data, serial->length);
    }
    *out = add2av(*out, cp);
    cp = NULLCP;

    /* issuer field */
    *out = add2av(*out, add2cp(NULLCP, C_ISSUER_DN));
    if ((issuer_cert(&cert, &dname, READ) == OK)
	&& (dname != NULLBB)) {
	(void) disp_dn(dname, &tav);
	prefixav (tav, "    ");
	*out = addav2av(*out, tav);
	FREE_AV(tav);
    }
    /* validity period field */
    *out = add2av(*out, add2cp(NULLCP, C_VALID));
    if ((valid_cert(&cert, &begin, &end, READ)) == OK) {
	/* valid.begin field */
	cp = add2cp(cp, CV_BDATE);
	c = ctime(&begin);
	c[strlen(c)-1] = NULLC;
	cp = add2cp(cp, c);
	*out = add2av(*out, cp);
	cp = NULLCP;

	/* valid.end field */
	cp = add2cp(cp, CV_EDATE);
	c = ctime(&end);
	c[strlen(c)-1] = NULLC;
	cp = add2cp(cp, c);
	*out = add2av(*out, cp);
	cp = NULLCP;
    }

    /* subject field */
    *out = add2av(*out, add2cp(NULLCP, C_SUBJECT_DN));
    if ((subject_cert(&cert, &dname, READ) == OK)
	&& (dname != NULLBB)) {
	(void) disp_dn(dname, &tav);
	prefixav(tav, "    ");
	*out = addav2av(*out, tav);
	FREE_AV(tav);
    }
    /* subject public key information field */
    *out = add2av(*out, add2cp(NULLCP, C_SPKI));
    if ((key_cert(&cert, &spk, READ) == OK)
	&& (spk != NULLBB)) {
	(void) disp_key(spk, &tav);
	prefixav(tav, "    ");
	*out = addav2av(*out, tav);
	FREE_AV(tav);
    }

    /* outer sig_alg identifier field */
    *out = add2av(*out, add2cp(NULLCP, C_ALG_OUT));
    if ((sig_alg_cert(&cert, &aid, OUTER, READ)) == OK) {
	(void) disp_algid(aid, &tav);
        prefixav(tav, "    ");
        *out = addav2av(*out, tav);
        FREE_AV(tav);
    }

    /* signature field */
    cp = add2cp(cp, C_SIGNATURE); 
    if ((sig_cert(&cert, &sig, &slen, READ)) == OK) 
	*out = add2av(*out, addhex2cp(cp, sig, slen));
    

    FREE_BBUF(dname);
    FREE_BBUF(spk);
    FREE_ALGID(aid);
    FREE_BBUF(serial);
    FREE_UCHAR(sig);

    return(OK);
}



int disp_cert_status(status, out)
unsigned short status;
char ***out;
{

    if (out == (char ***)0) 
	return(NOTOK);

    /* BNOTOK only turned off if flagged in the database */
    if (status == BNOTOK) {
	*out = add2av(*out, add2cp(NULLCP, "certificate is valid"));
	return(OK);
    }

    if (status == BUNKNOWN) {
	*out = add2av(*out, add2cp(NULLCP, "certificate status is unknown"));
	return(OK);
    }

    if (!(status & BNOTOK))
	*out = add2av(*out, 
		      add2cp(NULLCP, "certificate is designated valid"));
    else if (status & BSLFSGN)
	*out = add2av(*out,
		      add2cp(NULLCP, "certificate is NOT designated valid"));

    if (status & BBADCHN)
	*out = add2av(*out, add2cp(NULLCP, 
			   "certification path has an invalid certificate"));

    if (status & BNOVAL)
	*out = add2av(*out, add2cp(NULLCP, 
			   "certificate validity period is not present"));
    else if (status & BBADVAL)
	*out = add2av(*out, add2cp(NULLCP, "certificate has expired"));
    else ;

    if (status & BNOSIG)
	*out = add2av(*out, add2cp(NULLCP, 
				   "certificate signature is not present"));
    else if (status & BNOISS)
	*out = add2av(*out, add2cp(NULLCP, 
				   "issuer certificate is not present"));
    else if (status & BBADSIG)
	*out = add2av(*out, add2cp(NULLCP, 
				   "certificate signature is invalid"));
    else ;

    if (status & BNOCRL)
	*out = add2av(*out, add2cp(NULLCP, "issuer CRL is not present"));
    else if (status & BBADCRL)
	*out = add2av(*out, add2cp(NULLCP, 
				   "certificate has been revoked by issuer"));
    else ;

    if (status & BNOSDN)
	*out = add2av(*out, add2cp(NULLCP, 
				   "certificate subject name is not present"));
    else if (status & BNOIDN)
	*out = add2av(*out, add2cp(NULLCP, 
				   "certificate issuer name is not present"));
    else if (status & BSLFSGN)
	*out = add2av(*out, add2cp(NULLCP, "certificate is self-signed"));
    else ;

    return(OK);
}

