/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "cert.h"
#include "util.h"

static int _decode_ctbs(), _decode_valid(), decode_cert_data();


int decode_cert(ecert,dcert)
struct bbuf *ecert;
struct certificate **dcert;
{
    /* CHECK PARAMETERS */
    if (ecert == NULLBB) {
	return(NOTOK);
    }
    if (dcert == (struct certificate **)0) {
	return(NOTOK);
    }
    FREE_CERT(*dcert);
    if (alloc_cert(dcert) != OK)
	return(NOTOK);

    /* DECODE CERT_DATA */
    if (ecert->length && decode_cert_data(ecert, dcert) != OK) {
	FREE_CERT(*dcert);
	return(NOTOK);
    }
    (*dcert)->status = ecert->status;

    return(OK);
}


static int decode_cert_data(ecd, dcd)
struct bbuf *ecd;
struct certificate **dcd;
{
    int ret = NOTOK;
    int dummy;
    struct bbuf *ptr, *bbufs = NULLBB;

    /* Check for valid tag */
    if ((ecd->data[0] & TAG_MASK) != CONS_SEQ
        || asn_parse(ecd, &bbufs) != OK) 
        goto cleanup;

    /* ALLOCATE CERT */
    if (alloc_cert(dcd) != OK) 
        goto cleanup;

    /* TOBESIGNED */
    if ((ptr = bbufs) == NULLBB) {
        ret = OK;
        goto cleanup;
    }
    if (ptr->length && _decode_ctbs(ptr, &((*dcd)->tobesigned)) != OK)
        goto cleanup;

    /* SIGNATURE ALGORITHM */
    if ((ptr = ptr->next) == NULLBB) {
        ret = OK;
        goto cleanup;
    }
    if (ptr->length && decode_algid(ptr, &((*dcd)->sig_alg), &dummy) != OK)
        goto cleanup;

    /* SIGNATURE */
    if ((ptr = ptr->next) == NULLBB) {
        ret = OK;
        goto cleanup;
    }
    if (ptr->length && decode_bits(ptr, &((*dcd)->sig), &dummy) != OK)
        goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK) 
        FREE_CERT(*dcd);

    return(ret);
}


static int _decode_ctbs(etbs, dtbs)
struct bbuf *etbs;
struct tobesigned **dtbs;
{
    int dummy;
    struct bbuf *ptr, *bbufs = NULLBB;
    int ret = NOTOK;

    /* Check for valid tag */
    if ((etbs->data[0] & TAG_MASK) != CONS_SEQ
	|| asn_parse(etbs, &bbufs) != OK) 
        goto cleanup;

    /* ALLOCATE CERT TOBESIGNED */
    *dtbs = alloc_tobesigned_cert();
	
    /* SERIAL */
    if ((ptr = bbufs) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_ints(ptr, &((*dtbs)->serial), &dummy) != OK)
	goto cleanup;

    /* SIGNATURE ALGORITHM */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_algid(ptr, &((*dtbs)->sig_alg), &dummy) != OK)
        goto cleanup;

    /* ISSUER DN */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length > 2 && ((*dtbs)->issuer=dup_bbuf(ptr)) == NULLBB) 
	goto cleanup;

    /* VALIDITY PERIOD */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && _decode_valid(ptr, &((*dtbs)->valid)) != OK)
	goto cleanup;

    /* SUBJECT DN */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length > 2 && ((*dtbs)->subject=dup_bbuf(ptr)) == NULLBB) 
	goto cleanup;

    /* PUBLIC KEY */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length > 2 && ((*dtbs)->public=dup_bbuf(ptr)) == NULLBB) 
	goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK) 
	FREE_TOBESIGNED(*dtbs);

    return(ret);
}


static int _decode_valid(eval, dval)
struct bbuf *eval;
struct valid **dval;
{
    struct bbuf *ptr, *bbufs = NULLBB;
    int dummy, ret = NOTOK;

    /* Check for valid tag */
    if ((eval->data[0] & TAG_MASK) != CONS_SEQ
	|| asn_parse(eval, &bbufs) != OK) 
        goto cleanup;

    /* DECODE VALIDITY PERIOD */
    *dval = alloc_valid_cert();
    if ((ptr = bbufs) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_utct(ptr, &((*dval)->begin), &dummy) != OK)
	goto cleanup;

    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_utct(ptr, &((*dval)->end), &dummy) != OK)
	goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK)
	FREE_VALID(*dval);

    return(ret);
}
