/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_len(dlen, elen)
int dlen;
struct bbuf **elen;
{
    if (elen == (struct bbuf **)0) 
	return(NOTOK);

    if (*elen != NULLBB) {
	(void) free_bbuf(*elen);
	*elen = NULLBB;
    }

    *elen = alloc_bbuf();

    if (dlen < 128) {
	/* SHORT FORM DEFINITE LENGTH ENCODING */
	(*elen)->data = alloc_uchar(1);
	(*elen)->data[0] = dlen & LEN_MASK;
	(*elen)->length = 1;
    } else {
	int i, llen, x;

	llen = 0; x = dlen;
	do { llen++; } while (x /= 0x100);
	(*elen)->data = alloc_uchar(llen+1);
	x = dlen;
	for (i=llen; i>0; i--) {
	    (*elen)->data[i] = x % 0x100;
	    x /= 0x100;
	}
	(*elen)->data[0] = llen | LEN_XTND;
	(*elen)->length = llen + 1;
    }

    return(OK);
}
