/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

struct bbuf *bits2prim(bits)
struct bbuf *bits;
{
    struct bbuf *bb;
    int i;
    unsigned char *Sp, *dp;
	
    if (bits == (struct bbuf *)0) 
	return(NULLBB);

    bb = alloc_bbuf();
    bb->data = alloc_uchar(bits->length+1);
    bb->length = bits->length + 1;
    bb->data[0] = bits->blength;
    for(i=0, Sp=bits->data, dp=bb->data+1; i<bits->length; i++, Sp++, dp++) {
	*dp = *Sp << bits->blength;
	if (i+1 < bits->length)
	    *dp |= *(Sp+1) >> (8 - bits->blength);
    }

    return(bb);
}
