/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef MOSSDEF_HEADER
#define MOSSDEF_HEADER

/*  This file contains definitions needed for interaction with TIS/MOSS */

/* 
 * Default sendproc script used; init.c looks for user's sendproc entry, if any
 * in .mh_profile.
 */
#define DEFAULT_SENDPROC "mosssend.sh"

/* program to check if you are logged into MOSS */
#define MOSS_LOG_CHECK "mosslogcheck alias sig-user 1>/dev/null 2>&1"

/* used to flag a composition window as having a MOSS enhanced message */
#define MOSS_ENHANCED_MSG  1

#define QUIT  1
#define OK    0

#define MOSS_NOT_SUPPORTED  "MOSS: You must use the #privacy directive on first line to sign and encrypt."
#define MOSS_NOT_SUPPORTED2 "MOSS: You must use the #encrypt directive on first line to encrypt."

#define MOSS_LOG_NOTICE "You can not perform this MOSS option because you are not logged into MOSS.\nYou must run mosslogin first."


typedef enum moss_op { MOSS_UNKNOWN_OP, MOSS_NOSEND, MOSS_SIGN, MOSS_ENCRYPT, MOSS_SIGN_ENCRYPT } MOSS_Op;

typedef struct MsgAndDiag {
    Msg         msg;
    Widget      dialog;
} MsgAndDiagRec, *MsgAndDiag;



#endif
