#!/bin/sh

# Help if necessary

if [ $# -ne 0 ]; then
  echo "$0 takes a MOSS message on standard input, peels away one layer" 1>&2
  echo "of MOSS, and places the resulting MIME object on standard output." 1>&2
  exit 1
fi

# Temporary file names

tmpfile1="/tmp/peelp$$.1"
tmpfile2="/tmp/peelp$$.2"

# Default status and exit trap

status=1
trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

# Umask set for maximum protection

umask 177

# Check args

if [ $# -ne 0 ]; then
   echo " " 1>&2
   echo "Usage: $0" 1>&2
   echo " " 1>&2
   exit 
fi

cat > $tmpfile1

peelmoss.sh $tmpfile1 $tmpfile2
status=$?

if [ $status -ne 0 ]; then
   echo "$0: Bad return from peelmoss.sh ($status)." 1>&2
else
   cat $tmpfile2
   status=$?
fi


exit