#!/bin/sh

# Temporary file names

tmpfile1="/tmp/peel$$.1"
tmpfile2="/tmp/peel$$.2"

# Default status and exit trap

status=1
trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

# Umask set for maximum protection

umask 177

# Check args

if [ $# -ne 2 ]; then
   echo " " 1>&2
   echo "Usage: $0 <MOSS message file> <MIME object file>" 1>&2
   echo " " 1>&2
   exit 
fi

if [ ! -r $1 ]; then
   echo "$0: Unable to read input file $1." 1>&2
   exit
fi

if [ ! -w $2 ]; then
   touch $2 2>&1 > /dev/null
   if [ ! -w $2 ]; then
      echo "$0: Unable to write output file $2." 1>&2
      exit 
   fi
fi

# Extract Content-Type header

ct=`sed -n '1,/^$/ p' $1 | \
    sed -n '/^[Cc][Oo][Nn][Tt][Ee][Nn][Tt]-[Tt][Yy][Pp][Ee]/,/^[A-Za-z]/ p' | \
    sed '$ D' | \
    awk '{for (i=1; i <=NF; i++) printf "%s ", $i}' | \
    awk -F\; '{for (i=1; i<=NF; i++) print $i}'`

# See if it an application/moss-key or application/moss-signature 

echo "$ct" | fgrep -i -s "application/moss-keys"
enc=$?
echo "$ct" | fgrep -i -s "application/moss-signature"
sig=$?

if [ $sig -eq 1 -a $enc -eq 1 ]; then
   echo "Not a MOSS message!" 1>&2
   exit
fi

# Extract the boundary marker and escape special characters.

b=`echo "$ct" | \
  sed -n 's/[Bb][Oo][Uu][Nn][Dd][Aa][Rr][Yy]\=\(.*\)$/\1/p' | \
  sed 's/^[ 	]*//; s/[ 	]*$//; s/"\(.*\)"/\1/g; s/\\./\\\\./g; 
       s/\\?/\\\\?/g; s;/;\\\\/;g;'`

if [ "$b" = "" ]; then
   echo "$0: Unable to find boundry marker." 1>&2
   exit
fi

# Process message types

if [ $sig -eq 0 ]; then

  echo "This is a SIGNED MOSS message."

  sed -n "1,/^--$b$/ d; /^--$b$/,/^--$b--$/ p" $1 | \
     sed '1 d; $ d' | sed '$ d' | \
     decode.sh > $tmpfile1

  status=$?
  if [ $status -ne 0 ]; then
     echo "$0: Unable to decode headers --  decode.sh returned $status." 1>&2
     exit
  fi

  sed "1,/^--$b$/ d; /^--$b$/,$ d" $1 | sed '$ d' | tee $2 | canon | \
  verify header-in $tmpfile1

  status=$?
  if [ $status -ne 0 ]; then
     echo "$0: Unable to verify message ($status)." 1>&2
     exit
  fi

  status=$?
  if [ $status -ne 0 ]; then
     echo "$0: Unable to decode message --  decode.sh returned $status." 1>&2
     exit
  fi

else

  echo "This is an ENCRYPTED MOSS message."

  sed "1,/^--$b$/ d; /^--$b$/,$ d" $1 | sed '$ d' | decode.sh > $tmpfile1

  status=$?
  if [ $status -ne 0 ]; then
     echo "$0: Unable to decode key info --  decode.sh returned $status." 1>&2
     exit
  fi

  sed -n "1,/^--$b$/ d; /^--$b$/,/^--$b--$/ p" $1 | \
     sed '1 d; $ d' | \
     sed '$ d' | \
     decode.sh > $tmpfile2

  status=$?
  if [ $status -ne 0 ]; then
     echo "$0: Unable to decode message --  decode.sh returned $status." 1>&2
     exit
  fi

  decrypt header-in $tmpfile1 data-in $tmpfile2 data-out $2
  status=$?

fi

exit 
