/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "dname.h"
#include "new.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd,bb));
}

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd,bb));
}

mossdisp_main (argc, argv)
int argc;
char **argv;
{
    int ret = NOTOK;
    struct cbstruct iocbs;
    char **template = NULLVP;
    char **av = NULLVP;
    char **user = NULLVP;
    char *dnstr = NULLCP;
    
    /* check args, display help */

    if (moss_init(argc, argv, &template) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    if (argc < 2 || !strcasecmp (argv[1], "help") || template == NULLVP) {
        (void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s <tag> <value> [...]\n", myname);
	goto cleanup;
    }

    /* Canonicalize distinguished names */

    if ((av = tag_user(template, "subject-name")) != NULLVP) {
	if ((dnstr = canon_str(*(av+1))) == NULLCP) {
	    (void) fprintf(stderr, "%s: subject-name %s is invalid.\n",
			   myname, *(av+1));
	    goto cleanup;
	}
	FREE(*(av+1));
	*(av+1) = dnstr;
	dnstr = NULLCP;
    }

    if ((av = tag_user(template, "issuer-name")) != NULLVP) {
	if ((dnstr = canon_str(*(av+1))) == NULLCP) {
	    (void) fprintf(stderr, "%s: issuer-name %s is invalid.\n",
			   myname, *(av+1));
	    goto cleanup;
	}
	FREE(*(av+1));
	*(av+1) = dnstr;
	dnstr = NULLCP;
    }
    
    /* Set up cb for moss_disp */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;

    while ((user = get_tvt_user(template)) != NULLVP) {
	if ((ret=moss_disp(user, &iocbs)) != OK) {
	    (void) fprintf(stderr, "%s: Unable to display user\n", myname);
	    goto cleanup;
	}
	FREE_AV(user);
    }

 cleanup:

    return ret;
}
