//
// residue.hxx
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _RESIDUECLASS_HXX
#define _RESIDUECLASS_HXX

#include <linteger/linteger.hxx>

class ResidueClass 
{
private:
  static LInteger ring;
  LInteger _principalResidue;
public:
  ResidueClass(); 
  ResidueClass(const LInteger& x);
  ResidueClass(const ResidueClass& x);
  ~ResidueClass();

  inline ResidueClass& operator=(const ResidueClass& x);

  static inline ResidueClass MultiplicativeIdentity();

  static inline const LInteger& Ring();
  static inline LInteger SetRing(const LInteger& newRing); 

  inline ResidueClass& operator*=(const ResidueClass& x);

  inline ResidueClass& Square();

  inline LInteger ToLInteger() const;
}; 

#include <linteger/residue.inl>

#endif
