//
// sha.hxx
//
// Abstract base class for the two versions of the
// NIST/NSA's Secure Hash Algorithm
// (first defined in FIPS180 but modified in FIPS180-1)
//
// this implementation
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _SHA_HXX
#define _SHA_HXX

#include <chnhash/chnhash.hxx>

class SHA : public ChainHash 
{
protected:
  virtual void ProcessBuf()=0;

  u32 H[5];
  u32 buf[16];
public:
  SHA();
  virtual ~SHA();

  void ProcessMiddleBlock(const void* block);
  void ProcessFinalBlock(const void* block, const int size);

  void Reset();

  void ChainVariables(void* buffer) const;

  const u32 H0=0x67452301;
  const u32 H1=0xefcdab89;
  const u32 H2=0x98badcfe;
  const u32 H3=0x10325476;
  const u32 H4=0xc3d2e1f0;
};

#endif
