// lmisc.asm
//
// Leonard Janke 
// August 1996

inline void LMisc::MemZero(unsigned int* A, const int size)
{
  asm volatile("cld\n\t"
	       "movl $0, %%eax\n\t"
	       "repe\n\t"
	       "stosl (%%edi)\n\t"
	       :
	       : "D" (A), "ecx" (size)
	       : "%edi", "%ecx", "%eax"
	       );
}

inline void LMisc::MemCopy(const unsigned int* source, unsigned int* dest, 
			   const int size)
{
  asm volatile("cld\n\t"
	       "rep\n\t"
	       "movsl (%%esi), (%%edi)\n\t"
	       :
	       : "S" (source), "D" (dest), "ecx" (size)
	       : "%ecx", "%esi", "%edi", "memory"
	       );
}
  
