/* Implement hash tables.  This is -*- C++ -*- code.
   Copyright (C) 1992 Per Bothner.

This file is part of Q.

Q is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Q is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "gennum.h"

extern "C" volatile void abort();

/* Returns a (static) string for the assembler-level name of the
   virtual function table of a class names CLASS_NAME. */

main()
{
#define outfile stdout
    int ch;
    int ch_buf[2];
    int align = sizeof(void*);
    int to_align = align - (unsigned)1 % align; /* Forces 1 NUL byte. */
    ch_buf[1] = 0;
    fprintf(outfile, "extern char VT_StringC[1] asm(\"%s\");\n",
	    emit_vtable_name ("StringC"));
    fprintf(outfile, "extern char VT_Character[1] asm(\"%s\");\n",
	    emit_vtable_name ("Character"));
    fprintf(outfile, "extern char VT_SmallInt[1] asm(\"%s\");\n",
	    emit_vtable_name ("SmallInt"));
    fprintf(outfile, "extern struct Package AlphabetPackage;\n");
    fprintf(outfile, "extern struct NilClass NilSymbol;\n");
    fprintf(outfile, "struct String { char *vt; long len; char bytes[2];};\n");
    fprintf(outfile, "struct Character {\n");
    fprintf(outfile, "  char *vt;\n");
    fprintf(outfile, "  struct NilClass *_property_list;\n");
#ifdef C_SYM
    fprintf(outfile, "  const char *_pchars;\n");
#else
    fprintf(outfile, "  const struct String *_pname;\n");
#endif
    fprintf(outfile, "  struct Package *_package;\n");
    fprintf(outfile, "  void *_value;\n");
#ifdef C_SYM
    fprintf(outfile, "  int _flags : 8;\n");
    fprintf(outfile, "  int _plength : 24;};\n");
#else
    fprintf(outfile, "  int _flags;};\n");
#endif

    fprintf(outfile, "struct SmallInt {\n");
    fprintf(outfile, "  char *vt;\n");
    fprintf(outfile, "  unsigned long len;\n");
    if (sizeof(fix_int) == sizeof(int))
	fprintf(outfile, "  int val; };\n");
    else if (sizeof(fix_int) == sizeof(short))
	fprintf(outfile, "  short val; };\n");
    else if (sizeof(fix_int) == sizeof(long))
	fprintf(outfile, "  long val; };\n");
    else
	abort();

    fprintf(outfile, "struct SmallInt SmallIntTable[%d] = {\n",
	    CountSmallInt);
    for (int i = 0; i < CountSmallInt; i++)
	fprintf(outfile, "  { VT_SmallInt, 1, %d},\n", i + LeastSmallInt);
    fprintf(outfile, "};\n");


    for (ch = 0; ch < 256; ch++) {
	fprintf(outfile,
		"const static struct String Str%d = "
		"{VT_StringC, 1, {'\\%o','\\0'}};\n",
		ch, ch);
    }
    fprintf(outfile, "struct Character CharTable[256] = {\n");
    for (ch = 0; ch < 256; ch++) {
	fprintf(outfile,
#ifdef C_SYM
		" { VT_Character, &NilSymbol, Str%d.bytes, &AlphabetPackage, 0, 1, 1},\n",
		ch);
#else
		" { VT_Character, &NilSymbol, &Str%d, &AlphabetPackage, 0, 1},\n",
		ch);
#endif
    }
    fprintf(outfile, "};\n");
    return 0;
}
