//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : memory.c 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#include <LiDIA/lidia.h>
#include <stdlib.h>

void default_memory_handler(char *f, char *m)
{
  cout << "\n memory_handler";
  cout << "::" << f;
  cout << "::" << m;
  cout << "memory exhausted\n";
  cout.flush();
  abort();
}

memory_handler_ptr lidia_memory_handler = default_memory_handler;

memory_handler_ptr set_memory_handler(memory_handler_ptr new_handler)
{
  memory_handler_ptr old_handler = lidia_memory_handler;
  lidia_memory_handler = new_handler;
  return old_handler;
}
