//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : bigint.c (implementation of the gmp interface) 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#include <LiDIA/bigint.h>
#include <math.h>
#include <ctype.h>
#include <stdio.h>

/**
** constructors and destructor; we could leave out some of these
**/

bigint::bigint()
{ } 

bigint::bigint(int i)
{ } 

bigint::bigint(long l)
{ }

bigint::bigint(unsigned long ul)
{ }

bigint::bigint(double d)
{ }

bigint::bigint(const bigint & a)
{ }

bigint::~bigint()
{ }

/**
** inline member functions
**/

int bigint::bit(unsigned int i) const
{ }

int bigint::length() const
{ } 

int bigint::bit_length() const
{ } 

int bigint::sign() const
{ } 

int bigint::is_positive() const
{ } 

int bigint::is_negative() const
{ }

int bigint::is_even() const
{ }

int bigint::is_odd() const
{ }

int bigint::is_zero() const
{ }

int bigint::is_gt_zero() const
{ }

int bigint::is_ge_zero() const
{ }

int bigint::is_lt_zero() const
{ }

int bigint::is_le_zero() const
{ }

int bigint::is_one() const
{ }

int bigint::intify(int & i) const
{ }

int bigint::longify(long & i) const
{ }

int bigint::abs_compare(const bigint & a) const
{ }

int bigint::compare(const bigint & a) const
{ }

unsigned long bigint::most_significant_digit() const
{ }

unsigned long bigint::least_significant_digit() const
{ }

const double bigint::radix()
{ }

const int bigint::bits_per_digit()
{ }

void bigint::absolute_value()
{ }

void bigint::negate()
{ }

void bigint::assign_zero()
{ }

void bigint::assign_one()
{ }

void bigint::assign(int i)
{ }

void bigint::assign(long ui)
{ }

void bigint::assign(unsigned long ui)
{ }

void bigint::assign(const bigint & a) 
{ }

void bigint::multiply_by_2() 
{ }

void bigint::divide_by_2()
{ }

/**
** Type checking
**/

int is_char(const bigint & a)
{ }

int is_uchar(const bigint & a)
{ }

int is_short(const bigint & a)
{ }

int is_ushort(const bigint & a)
{ }

int is_int(const bigint & a)
{ }

int is_uint(const bigint & a)
{ }

int is_long(const bigint & a)
{ }

int is_ulong(const bigint & a)
{ }

/**
** assignments
**/


int bigint::operator = (int i)
{ }

long bigint::operator = (long l)
{ }

unsigned long bigint::operator = (unsigned long ul)
{ }

double bigint::operator = (double d)
{ } 

bigint & bigint::operator = (const bigint & a)
{ }

/**
** comparisons
**/

int operator == (const bigint & a, const bigint & b)
{ }

int operator != (const bigint & a, const bigint & b)
{ }

int operator > (const bigint & a, const bigint & b)
{ }

int operator >= (const bigint & a, const bigint & b)
{ }

int operator < (const bigint & a, const bigint & b)
{ }

int operator <= (const bigint & a, const bigint & b)
{ }

/**
** operator overloading
**/

bigint operator - (const bigint & a)
{ }

bigint operator + (const bigint & a, const bigint & b)
{ }

bigint operator - (const bigint & a, const bigint & b)
{ }

bigint operator * (const bigint & a, const bigint & b)
{ }

bigint operator / (const bigint & a, const bigint & b)
{ 
  bigint c, r; 
  uIdiv(&c.I, &r.I, &a.I, &b.I); 
  if (c.I.length)
    c.I.sign = a.I.sign ^ b.I.sign;
  return c; 
}

bigint operator % (const bigint & a, const bigint & b)
{ 
  bigint c, q; 
  uIdiv(&q.I, &c.I, &a.I, &b.I); 
  if (c.I.length)
     c.I.sign = a.I.sign;
  return c; 
}

bigint operator << (const bigint & a, unsigned long ui)
{ }

bigint operator >> (const bigint & a, unsigned long ui)
{ }

bigint operator & (const bigint & a, const bigint & b)
{ }

bigint operator | (const bigint & a, const bigint & b)
{ }

bigint operator ^ (const bigint & a, const bigint & b)
{ bigint c; IasIxorI(&c.I, &a.I, &b.I); return c; }

bigint & bigint::operator += (const bigint & a)
{ }

bigint & bigint::operator -= (const bigint & a)
{ }

bigint & bigint::operator *= (const bigint & a)
{ }

bigint & bigint::operator /= (const bigint & a)
{ }

bigint & bigint::operator %= (const bigint & a)
{ }

bigint & bigint::operator <<= (unsigned long ui)
{ }

bigint & bigint::operator >>= (unsigned long ui)
{ }

bigint & bigint::operator &= (const bigint & a)
{ }

bigint & bigint::operator |= (const bigint & a)
{ }

bigint & bigint::operator ^= (const bigint & a)
{ }

bigint & bigint::operator++ ()
{ }

bigint & bigint::operator-- ()
{ }

int bigint::operator ! ()
{ }

bigint bigint::operator ~ ()
{ }

/**
** Procedural versions
**/

void negate(bigint & a, const bigint & b)
{ }

void add(bigint & c, const bigint & a, const bigint & b)
{ }

void subtract(bigint & c, const bigint & a, const bigint & b)
{ }

void multiply(bigint & c, const bigint & a, const bigint & b)
{
  if (&a == &b)
  {
  }
  else
}

void divide(bigint & c, const bigint & a, const bigint & b)
{ 
  bigint r;
  int sa = a.I.sign;
  int sb = b.I.sign;
  uIdiv(&c.I, &r.I, &a.I, &b.I); 
  if (c.I.length)
    c.I.sign = sa ^ sb;
}

void remainder(bigint & c, const bigint & a, const bigint & b)
{ 
  bigint q; 
  int sa = a.I.sign;
  uIdiv(&q.I, &c.I, &a.I, &b.I); 
  if (c.I.length)
      c.I.sign = sa;
}

void div_rem(bigint & q, bigint & r, const bigint & a, const bigint & b)
{ 
  int sa = a.I.sign;
  int sb = b.I.sign;
  uIdiv(&q.I, &r.I, &a.I, &b.I); 
  if (q.I.length)
    q.I.sign = sa ^ sb;
  if (r.I.length)
      r.I.sign = sa;
}

void shift_left(bigint & c, const bigint & a, long ui)
{ 
  if (ui < 0) 
    lidia_error_handler("bigint", "shift_left()::index is negative.");
}

void shift_right(bigint & c, const bigint & a, long ui)
{ 
  if (ui < 0) 
    lidia_error_handler("bigint", "shift_right()::index is negative.");
}

void power(bigint & c, const bigint & a, const bigint & b)
{
  bigint exponent, multiplier;
  if (b.is_negative())
    c.assign_zero();
  else if (b.is_zero() || a.is_one())
    c.assign_one();
  else
  {
   exponent.assign(b);
   multiplier.assign(a);
   c.assign_one();
   while (exponent.is_gt_zero())
   {
    if (!exponent.is_even())
      multiply(c, c, multiplier);
    square(multiplier, multiplier);
    exponent.divide_by_2();
   }
  }
}

void power(bigint & c, const bigint & a, long i)
{
  if (i == 0 || a.is_one())
  else if (i < 0)
  else 
} 

void and(bigint & c, const bigint & a, const bigint & b)
{ }

void or(bigint & c, const bigint & a, const bigint & b)
{ }

void xor(bigint & c, const bigint & a, const bigint & b)
{ }

void not(bigint & b, const bigint & a)
{ }

void inc(bigint & c)
{ }

void dec(bigint & c)
{ }

void add(bigint & c, const bigint & a, long i)
{ }

void subtract(bigint & c, const bigint & a, long i)
{ }

void multiply(bigint & c, const bigint & a, long i)
{ }

void divide(bigint & c, const bigint & a, long i)
{
  int s = 0;
  int sa = a.I.sign;
  if (i < 0)
  {
    s = 1;
    i = -i;
  }
  uIasIdiD(&c.I, &a.I, i);
  if (c.I.length)
    c.I.sign = sa ^ s;
}
  

void remainder(long &r, const bigint & a, long i)
{
  bigint q; 
  if (i < 0)
    i = -i;
  r = uIasIdiD(&q.I, &a.I, i);
  if (r)
  {
      if (a.I.sign)
        r = -r;
  }
}

long remainder(const bigint & a, long i)
{
  long r; 
  remainder(r, a, i);
  return r;
}

void div_rem(bigint & q, long &r, const bigint & a, long i)
{
  int s = 0;
  int sa = a.I.sign;
  if (i < 0)
  {
    s = 1;
    i = -i;
  }
  r = uIasIdiD(&q.I, &a.I, i);
  if (q.I.length)
    q.I.sign = sa ^ s;
  if (r)
  {
      if (sa)
        r = -r;
  }
}

/**
** gcd's
**/

bigint gcd(const bigint & a, const bigint & b)
{ }

bigint bgcd(const bigint & a, const bigint & b)
{ }

bigint dgcd(const bigint & a, const bigint & b)
{ }

bigint xgcd(bigint & u, bigint & v, const bigint & a, const bigint & b)
{ }

bigint xgcd_left(bigint & u, const bigint & a, const bigint & b)
{ }

bigint xgcd_right(bigint & v, const bigint & a, const bigint & b)
{ }

/**
** functions
**/

bigint abs(const bigint & a)
{ }

void seed(const bigint & a)
{ }

bigint randomize(const bigint & a)
{ }

double dbl(const bigint & a)
{
  double d; 
  char *s = new char[Ilog(&a.I)/3+10];
  Itoa(&a.I, s); 
  d = atof(s);
  delete s;
  return d;
}

void sqrt(bigint & a, const bigint & b)
{ }
      
void square(bigint & a, const bigint & b)
{ }

void swap(bigint & a, bigint & b)
{ }

/**
** input / output
**/

istream & operator >> (istream & in, bigint & a)
{     
#ifdef __GNUG__
                if (!in.ipfx0())
#else
                if (!in.ipfx(0))
#endif
                  return in;

                char s[10000];
                int ndigits = 0;

                char* p = s;
                int c;
                *p = '\0';
                do {
                  c = in.get();
                  if (c == EOF)
                  {
                    in.setf(ios::failbit|ios::eofbit); 
                    return in;
                  }
                  if ((c == '+') || (c == '-')) { *p++ = c; }
                } while (isspace(c) || (c == '+') || (c == '-'));

                if (!isdigit(c)) { cerr << "digit expected" << flush; }
                while (isdigit(c)) {
                  ndigits++;
                  *p++ = c;
                  c = in.get();
                  if (c == EOF)
                  {
                    *p = '\0';
                    string_to_bigint(s, a);
                    return in;
                  }

                }
                if (ndigits == 0)
                  {
                    in.setf(ios::failbit);
                    return in;
                  }

                *p = '\0';
                string_to_bigint(s, a);
                if (c != '\n' && c != '\r')
                  in.putback(c);
                return in;
}

ostream & operator << (ostream & out, const bigint & a)
{
  int l = Ilog(&a.I) + 10;
  char *s = new char[l / 3 + 2];
  Itoa(&a.I, s);
  out << s;
  delete s;
  return out;
}

int string_to_bigint(char *s, bigint & a)
{ }

int bigint_to_string(const bigint & a, char *s)
{ }

/**
** using fread/fwrite
**/

void bigint::read_from_file(FILE * fp)
{ }

void bigint::write_to_file(FILE * fp)
{ }

/**
** using fscanf/fprintf
**/

void bigint::scan_from_file(FILE * fp)
{ }

void bigint::print_to_file(FILE * fp)
{ }

