#include "iint.h"
#include <stdio.h>
#include "timing.h"

void main()
{
    Integer a, b, c, d, q, r, u, v;
    int count, i, j, l;
    unsigned long ticks;
    cI(&a);
    cI(&b);
    cI(&c);
    cI(&d);
    cI(&q);
    cI(&r);
    cI(&u);
    cI(&v);

    scanf("%d", &count);
    fscanI(stdin, &a);
    fscanI(stdin, &b);
    printf("%d %d\n", Ilog(&a), Ilog(&b));

/* Addition */
    IasI(&c, &a);
    Iinc(&a);
    Idec(&a);
    if (IneI(&a, &c))
	fprintf(stderr, "Fehler bei Iinc, Idec.\n");
    Idec(&a);
    Iinc(&a);
    if (IneI(&a, &c))
	fprintf(stderr, "Fehler bei Iinc, Idec.\n");

    ticks = timeticks();
    for (i = 0; i < count * 10; i++)
	IasIplI(&c, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d IasIplI %ld\n", count * 10, ticks);
    ImiasI(&c, &a);
    if (!IeqI(&b, &c))
	fprintf(stderr, "Fehler bei IasIplI!\n");

/* Multiplication */
    ticks = timeticks();	/* 100 Hz clock ticks */
    for (i = 0; i < count; i++)
	IasImuI(&c, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d  IasImuI  %ld\n", count, ticks);
    IdiasI(&c, &a);
    if (!IeqI(&b, &c))
	fprintf(stderr, "Fehler bei IasImuI!\n");

/* Division */
    IasImuI(&c, &a, &b);
    IasImuD(&d, &a, 3846);
    IplasI(&c, &d);		/* a*b + a*3846 */
    ticks = timeticks();
    for (i = 0; i < count / 2; i++)
	Idiv(&q, &r, &c, &b);	/* c==b*q+r */
    ticks = timeticks() - ticks;
    printf("%d Idiv %ld\n", count / 2, ticks);
    IasImuI(&d, &b, &q);
    IplasI(&d, &r);
    if (!IeqI(&d, &c))
	fprintf(stderr, "Fehler bei Idiv!\n");

/* Gcd */
    ticks = timeticks();
    for (i = 0; i < count / 10; i++)
	Idgcd(&d, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d Idgcd %ld\n", count / 10, ticks);

    ticks = timeticks();
    for (i = 0; i < count / 10; i++)
	Ibgcd(&c, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d Ibgcd %ld\n", count / 10, ticks);
    if (!IeqI(&d, &c))
	fprintf(stderr, "Fehler bei Idgcd/Ibgcd!\n");

/* Xgcd */
    ticks = timeticks();
    for (i = 0; i < count / 100; i++)
	Idxgcd(&d, &u, &v, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d Idxgcd %ld\n", count / 100, ticks);
    IasImuI(&c, &u, &a);
    IasImuI(&r, &v, &b);
    IplasI(&c, &r);
    if (!IeqI(&d, &c))
	fprintf(stderr, "Fehler bei Idxgcd!\n");
    ticks = timeticks();
    for (i = 0; i < count / 100; i++)
	Ibxgcd(&d, &u, &v, &a, &b);
    ticks = timeticks() - ticks;
    printf("%d Ibxgcd %ld\n", count / 100, ticks);
    IasImuI(&c, &u, &a);
    IasImuI(&r, &v, &b);
    IplasI(&c, &r);
    if (!IeqI(&d, &c))
	fprintf(stderr, "Fehler bei Ibxgcd!\n");

/* Shifts */
    l = Ilog(&a);
    ticks = timeticks();	/* 100 Hz clock ticks */
    for (i = 0; i < count / 10; i++)
    {
	IasI(&c, &a);
	for (j = 0; j < l; j++)
	{
	    Isr1(&c);
	}
    }
    ticks = timeticks() - ticks;
    printf("%d Isr1 %ld\n", count / 10 * l, ticks);
    if (!Ieq1(&c))
	fprintf(stderr, "Fehler bei Ilog/Isr1!\n");


/*	IprintStatistics();	*/

    dI(&a);
    dI(&b);
    dI(&c);
    dI(&d);
    dI(&q);
    dI(&r);
    dI(&u);
    dI(&v);
}
