

//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : vector.h 
// Author      : Frank Lehmann (FL), Markus Maurer (MM), 
//               Thomas Papanikolaou (TP)
// Last change : FL/MM, Feb 15 1995, initial version
//               FL/MM, May 10 1995, clean-up
//		 FL/MM, May 15 1995, changed type of size variables to base_vector<T>::size_type
//		 FL/MM, May 23 1995, removed math_sort_vector and file_sort_vector;
//		 FL/MM, Jul  6 1995, replaced base_vector<T>::size_type by lidia_size_t
//               FL/MM, Jul 24 1995, added 'const' to T* parameters of constructors


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
// *
// *    File        :  vector.h
// *
// *    Description :  -) definition of template class 'vector<T>'
// *                      to combine the capabilities of the classes
// *    	          'base_vector<T>', 'math_vector<T>', 'sort_vector<T>',
// *                      and 'file_vector<T>'
// *
// *                   -) virtual base classes are 'sort_vector<T>',
// * 			  'math_vector<T>', and 'file_vector<T>'
// *
// * 		       -) the requirements on type T are derived by those
// *			  of the corresponding base classes
// *
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


#ifndef LIDIA_VECTOR_H
#define LIDIA_VECTOR_H


#include <LiDIA/math_vector.h>
#include <LiDIA/sort_vector.h>
#include <LiDIA/file_vector.h>


 template <class T> class  vector : virtual public file_vector < T >,
                                          virtual public sort_vector < T >,
                                          virtual public math_vector < T >
 {

   public :

   // ***** constructor functions *****

   vector () : base_vector< T > ( FIXED )     
    {
       debug_handler ( "vector", "constructor ()" ) ;
    }

   vector (  char md ) :  base_vector< T > ( md )     
    {
       debug_handler ( "vector", "constructor ( char )" ) ;
    }


   vector (  lidia_size_t all ) : base_vector< T > ( all, FIXED ) 
    {
       debug_handler ( "vector", "constructor ( lidia_size_t )" ) ;
    }

   vector (  lidia_size_t all,  char md ) : base_vector< T > ( all, md ) 
    {
       debug_handler ( "vector", "constructor ( lidia_size_t, char )" ) ;
    }


   vector ( lidia_size_t all, lidia_size_t len ) : base_vector< T > ( all, len, FIXED )  
    {
       debug_handler ( "vector", "constructor ( lidia_size_t, lidia_size_t )" ) ;
    }

   vector ( lidia_size_t all, lidia_size_t len,  char md ) : base_vector< T > ( all, len, md )  
    {
       debug_handler ( "vector", "constructor ( lidia_size_t, lidia_size_t, char )" ) ;
    }


   vector ( const base_vector < T > & v ) : base_vector< T > ( v, FIXED )  
    {
       debug_handler ( "vector", "constructor ( base_vector < T > & )" ) ;
    }

   vector ( const base_vector < T > & v,  char md ) : base_vector< T > ( v, md )  
    {
       debug_handler ( "vector", "constructor ( base_vector < T > &, char  )" ) ;
    }


   vector ( const  T *v, lidia_size_t len ) : base_vector< T > ( v, len, FIXED )  
    {
       debug_handler ( "vector", "constructor ( const T *, lidia_size_t )" ) ;
    }

   vector ( const  T *v, lidia_size_t len,  char md ) : base_vector< T > ( v, len, md )  
    {
       debug_handler ( "vector", "constructor ( const T *, lidia_size_t, char )" ) ;
    }



   // ***** destructor *****

   LiDIA_VEC_VIRTUAL ~vector()
    {
      debug_handler ( "vector", "destructor()" ) ;

      //  memory deallocation is done by
      //  base_vector - destructor
    }


    // ***** assignment *****

    vector<T> & operator= ( const vector<T> & v ) 
     {
       debug_handler ( "vector", "operator=" ) ;
       
       if ( &v != this )

           base_vector<T>::operator= ( v ) ;
       
       return ( *this ) ;
     }   

 } ;


#endif








