//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : bigfloat_config.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_BIGFLOAT_CONFIG_H
#define LIDIA_BIGFLOAT_CONFIG_H

#if gcos
#define bits_per_char   9
#else
#define bits_per_char   8
#endif

#define bits_per_(type) (bits_per_char * (int)sizeof(type))
#define bits_per_short  bits_per_(short)
#define bits_per_int    bits_per_(int)
#define bits_per_double bits_per_(double)

#ifndef base_digit
#define base_digit unsigned long
#endif

#define base_digit_radix             (bigint::radix())
#define bits_per_base_digit          (bigint::bits_per_digit())
#define bits_per_base_digit_minus_1  (bits_per_base_digit - 1)

#define high_bit_short (1 << (bits_per_(short) - 1))
#define high_bit_int   (1 << (bits_per_(int) - 1))
#define high_bit_long  (1L << (bits_per_(long) - 1))

#define max_short        (~high_bit_short)
#define max_int          (~high_bit_int)
#define max_long         (~high_bit_long)

#define rounding_bits   (3 * bits_per_base_digit)
#define digits_per_double sizeof(double)/sizeof(base_digit)

#define log_base_digit_bits  (base_digit)(log((double)bits_per_base_digit)/log(2.))
#define max_base_digit       (base_digit)(exp((bits_per_base_digit-1)*log(2.)))
#define max_base_digit_2     (2.0*(double)max_base_digit)
#define log_max_pow_10       (base_digit)(bits_per_base_digit*log(2.)/log(10.))
#define max_pow_10           (base_digit)(exp(log_max_pow_10*log(10.))+0.5)

/* Constants */

#define L2B10           0.30102999566398119521	/* log(2)/log(10) */
#define LOG2            0.69314718055994530942	/* log(2) */
#define LOG10           2.30258509299404568401	/* log(10) */
#define INVLOG2         1.44269504088896340735	/* 1/log(2) */
#define INVLOG10        0.43429448190325182765	/* 1/log(10) */

/* Rounding Modes */

#define MP_TRUNC        0	/* round to zero */
#define MP_RND          1	/* round to nearest */
#define MP_RND_UP       2	/* round to +infinity */
#define MP_RND_DOWN     3	/* round to -infinity */

#endif
