/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    protected SecretKey engineGenerateKey() {
        DESKey dESKey = null;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            byte[] byArray = new byte[8];
            do {
                this.random.nextBytes(byArray);
                DESKeyGenerator.setParityBit(byArray, 0);
            } while (DESKeySpec.isWeak(byArray, 0));
            dESKey = new DESKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {}
        return dESKey;
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n != 56 && n != 64) {
            throw new InvalidParameterException("Wrong number of bits - must be 56 or 64");
        }
        this.engineInit(secureRandom);
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DES key generation does not take any parameters");
    }

    static void setParityBit(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < PARITY_BIT_MASK.length) {
                if ((byArray[n2 + n] & PARITY_BIT_MASK[n4]) == PARITY_BIT_MASK[n4]) {
                    ++n3;
                }
                ++n4;
            }
            byArray[n2 + n] = n3 & true ? (byte)(byArray[n2 + n] & 0xFFFFFFFE) : (byte)(byArray[n2 + n] | 1);
            ++n2;
        }
    }
}

