
; IDEA Encryption Program
; (C) Fauzan Mirza 1995

        .model  tiny
        .code

        org     100h

BufLen  equ     32768

Start:
        mov     si,80h
        lodsb
        or      al,al
        jnz     Begin

PrintUsage:
        mov     ah,9
        mov     dx,offset Usage
        int     21h

        mov     ax,4c01h
        int     21h

SkipSpaces:
        lodsb
        cmp     al,0dh
        jz      PrintUsage
        cmp     al,20h
        jz      SkipSpaces
        dec     si
        ret

AddZero:
        lodsb
        cmp     al,0dh
        jz      AddZ2
        cmp     al,20h
        jnz     AddZero
AddZ2:
        mov     byte ptr [si-1],0
        ret

Begin:
        call    SkipSpaces
        lodsb
        cmp     al,'-'
        jz      DeMode
        cmp     al,'+'
        jz      EnMode
        jmp     PrintUsage
DeMode:
        mov     byte ptr [Mode],255
EnMode:
        call    SkipSpaces
        mov     word ptr [Infile],si
        call    AddZero

        call    SkipSpaces
        mov     word ptr [Outfile],si
        call    AddZero
   
        mov     ah,9
        mov     dx,offset Enterkey
        int     21h

        mov     ah,0ah
        mov     dx,offset Password
        int     21h

        mov     si,offset Userkey
        mov     di,offset Key
        call    Expandkey

        mov     si,offset IV
        mov     di,offset CFBBuffer
        mov     cx,4
        repnz   movsw

        mov     ax,3d00h
        mov     dx,word ptr [Infile]
        int     21h
        jc      Error
        mov     word ptr [Infile],ax

        mov     ah,3ch
        xor     cx,cx
        mov     dx,word ptr [Outfile]
        int     21h
        jc      Error
        mov     word ptr [Outfile],ax

Again:
        mov     ah,3fh
        mov     bx,word ptr [Infile]
        mov     cx,BufLen
        mov     dx,offset Buffer
        int     21h
        jc      Error

        or      ax,ax
        jz      Done

        push    ax
        call    DoCrypt
        pop     cx

        mov     ah,40h
        mov     bx,word ptr [Outfile]
        mov     dx,offset Buffer
        int     21h
        jc      Error

        cmp     cx,BufLen
        jz      Again

Done:

        mov     ah,3eh
        mov     bx,word ptr [Outfile]
        int     21h

        mov     ah,3eh
        mov     bx,word ptr [Infile]
        int     21h

        mov     ax,4c00h
        int     21h

Error:
        mov     ah,09
        mov     dx,offset Message
        int     21h

        mov     ax,4c01h
        int     21h

DoCrypt:
        mov     si,offset Key
        mov     di,offset Buffer
        add     ax,7
        mov     cl,3
        shr     ax,cl
        mov     cx,ax
Block:
        push    cx
        push    si di
        cmp     byte ptr [Mode],0
        jnz     DoDecrypt
        call    Encrypt
        jmp     DoNextBlock
DoDecrypt:
        call    Decrypt
DoNextBlock:
        pop     di si
        add     di,8
        pop     cx
        loop    Block
        ret

; IDEA with CFB assembly implementation
; Written by Fauzan Mirza <F.U.Mirza@sheffield.ac.uk>

; Expand user key to encryption subkey
; si -> userkey, di -> encryption subkey

Expandkey:
        mov     bx,8
        mov     cx,bx
        repnz   movsw
CompleteKey:
        mov     ax,bx
        and     al,7
        cmp     al,6
        ja      Above
        jb      Below
        mov     ax,word ptr [di-14]
        mov     dx,word ptr [di-28]
        jmp     short Update
Above:
        mov     ax,word ptr [di-30]
        mov     dx,word ptr [di-28]
        jmp     short Update
Below:
        mov     ax,word ptr [di-14]
        mov     dx,word ptr [di-12]
Update:
        and     ax,127
        mov     cl,9
        shl     ax,cl
        mov     cl,7
        shr     dx,cl
        or      ax,dx
        stosw
        inc     bl
        cmp     bl,52
        jnz     CompleteKey
        ret

; IDEA subroutine
; si -> key, di -> data

x0      equ     word ptr [di]
x1      equ     word ptr [di+2]
x2      equ     word ptr [di+4]
x3      equ     word ptr [di+6]
t0      equ     bp
t1      equ     bx

IDEA:
        mov     cx,8
Round:
        mov     dx,x0
        call    MulMod
        mov     x0,ax
        lodsw
        add     x1,ax
        lodsw
        add     x2,ax
        mov     dx,x3
        call    MulMod
        mov     x3,ax

        mov     t0,x1
        mov     t1,x2
        mov     ax,x0
        xor     x2,ax
        mov     ax,x3
        xor     x1,ax

        mov     dx,x2
        call    MulMod
        mov     x2,ax
        add     x1,ax
        mov     dx,x1
        call    MulMod
        mov     x1,ax
        add     x2,ax

        mov     ax,x1
        xor     x0,ax
        mov     ax,x2
        xor     x3,ax
        xor     x1,t1
        xor     x2,t0
        loop    Round

        mov     dx,x0
        call    MulMod
        mov     x0,ax
        lodsw
        add     ax,x2
        mov     bx,x1
        mov     x1,ax
        lodsw
        add     ax,bx
        mov     x2,ax
        mov     dx,x3
        call    MulMod
        mov     x3,ax
        ret

; Multiplication modulo 63337
; ax = (->si) * dx

MulMod:
        push    dx
        lodsw
        mul     dx
        sub     ax,dx
        pop     dx
        jnz     NotZero
        mov     ax,1
        sub     ax,word ptr [si-2]
        sub     ax,dx
        jmp     short MulDone
NotZero:
        adc     ax,0
MulDone:
        ret

; Cipher Feedback
; bx -> buffer, si -> key, di-> data

CFBBuffer:
        db      8 dup(?)

xBuffer equ     offset CFBBuffer

Encrypt:
        push    di
        mov     di,xBuffer      ; di->buffer
        call    IDEA
        pop     si              ; si->data
        mov     cx,8
EnFeedback:
        lodsb
        xor     al,byte ptr [di]
        mov     byte ptr [si-1],al
        stosb
        loop    EnFeedback
        ret

Decrypt:
        push    di
        mov     di,xBuffer      ; di->buffer
        call    IDEA
        mov     si,di           ; si->buffer
        pop     di              ; di->data
        mov     cx,8
DeFeedback:
        lodsb
        mov     ah,byte ptr [di]
        mov     byte ptr [si-1],ah
        xor     al,ah
        stosb
        loop    DeFeedback
        ret

Usage:
        db      "IDEA Encryption Program",10,13
        db      "(C) Fauzan Mirza 1995",10,13,10,13
        db      "CRYPT [+|-] <InFile> <OutFile>",10,13,36

Enterkey:
        db      "Enter Key: ",36

Message:
        db      "File Access Error",10,13,36

Mode:
        db      0

Infile:
        dw      0

Outfile:
        dw      0

Password:
        db      16,0

Userkey:
        db      16 dup(0)

IV:
        dw      9d73h,1a08h,0f25eh,0b46ch

Key:
        dw      52 dup(?)

Buffer:
        db      BufLen dup(?)

        end     Start

