/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <syslog.h>
#include <errno.h>

/*
 * This file defines error logging functions
 */

void
init_log(void)
{
#ifndef DEBUG
    openlog("Pluto", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_AUTHPRIV);
#else
    setbuf(stderr, NULL);
    setbuf(stdout, NULL);
#endif
}

void
close_log(void)
{
#ifndef DEBUG
    closelog();
#endif
}

/*
 * If the first argument is true, then this is an error, otherwise
 * it's a warning. It takes up to three additional arguments (which
 * will be passed to syslog/printf verbatim.
 */
void
log(int error, char *message, int a, int b, int c)
{
#ifndef DEBUG
    if (error)
    {
	syslog(LOG_ERR, message, a, b, c);
	syslog(LOG_ERR, sys_errlist[errno], NULL);
    }
    else
      syslog(LOG_WARNING, message, a, b, c);
#else
    if (error)
      fprintf(stderr, "Error: ");
    fprintf(stderr,message, a, b, c);
    if (error)
      fprintf(stderr, "\nError: %s", sys_errlist[errno]);
    fprintf(stderr, "\n");
#endif
}

void
exit_log(char *message, int a, int b, int c)
{
    log(1, message, a, b, c);
    close_log();
    exit(-1);
}
