/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_xform.h,v 0.5 1997/06/03 04:24:48 ji Rel $
 *
 * $Log: ipsec_xform.h,v $
 * Revision 0.5  1997/06/03 04:24:48  ji
 * Added ESP-3DES-MD5-96
 *
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Added new transforms.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Definitions relevant to IPSEC transformations.
 */

struct tdb				/* tunnel descriptor block */
{
	struct tdb	*tdb_hnext;	/* next in hash chain */
	struct tdb	*tdb_onext;	/* next in output */
	struct tdb	*tdb_inext;	/* next in input (prev!) */
	__u32		tdb_spi;	/* SPI to use (in network order)*/
	struct in_addr	tdb_dst;	/* dest address for this SPI */
	struct ifnet	*tdb_rcvif;	/* related rcv encap interface */
	struct xformsw	*tdb_xform;	/* transformation to use (host order)*/
	caddr_t		tdb_xdata;	/* transformation data (opaque) */
};

#define TDB_HASHMOD	257

struct xformsw
{
	u_short		xf_type;	/* Unique ID of xform */
	u_short		xf_flags;	/* secondary type reall) */
	char		*xf_name;	/* human-readable name */
	int		(*xf_attach)(void);	/* called at config time */
	int		(*xf_init)(struct tdb *tdbp, struct xformsw *xsp, struct encap_msghdr *em);	/* xform initialization */
	int		(*xf_zeroize)(void);	/* termination */
	int		(*xf_print)(void *, char *);	/* /proc printing */
	int		(*xf_room)(struct tdb *, int, int, int *, int *); /* required head/tail room  */
	struct sk_buff 	*(*xf_input)(struct sk_buff *, struct tdb *);	/* called when packet received */
	int		(*xf_output)(struct sk_buff *, struct tdb *); /* called when packet sent */
};

#define XF_IP4		1		/* IP inside IP */
#define XF_AHMD5	2		/* AH MD5 */
#define XF_AHSHA	3		/* AH SHA */
#define XF_ESPDES	4		/* ESP DES-CBC */
#define XF_ESP3DES	5		/* ESP DES3-CBC */
#define XF_AHHMACMD5	6		/* AH-HMAC-MD5 with opt replay prot */
#define XF_AHHMACSHA1	7		/* AH-HMAC-SHA1 with opt replay prot */
#define XF_ESPDESMD5	8
#define XF_ESP3DESMD5	9
#define	XF_ESP3DESMD596	10	/* triple DES, HMAC-MD-5 with 96-bits of authentication */

#define XFT_AUTH	0x0001
#define XFT_CONF	0x0100

struct tdb *tdbh[TDB_HASHMOD];
extern struct xformsw xformsw[], *xformswNXFORMSW;

extern struct tdb *gettdb(u_long, struct in_addr);
extern void puttdb(struct tdb *);
extern int tdb_init(struct tdb *, struct encap_msghdr *);

extern int ipe4_attach(void);
extern int ipe4_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int ipe4_zeroize(void);
extern int ipe4_print(void *, char *);
extern int ipe4_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *ipe4_input(struct sk_buff *, struct tdb *);
extern int ipe4_output(struct sk_buff *, struct tdb *);


#ifdef CONFIG_IPSEC_AH_MD5
extern int ahmd5_attach(void);
extern int ahmd5_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int ahmd5_zeroize(void);
extern int ahmd5_print(void *, char *);
extern int ahmd5_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *ahmd5_input(struct sk_buff *, struct tdb *);
extern int ahmd5_output(struct sk_buff *, struct tdb *);
#endif

#ifdef CONFIG_IPSEC_AH_HMAC_MD5
extern int ahhmacmd5_attach(void);
extern int ahhmacmd5_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int ahhmacmd5_zeroize(void);
extern int ahhmacmd5_print(void *, char *);
extern int ahhmacmd5_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *ahhmacmd5_input(struct sk_buff *, struct tdb *);
extern int ahhmacmd5_output(struct sk_buff *, struct tdb *);
#endif

#ifdef CONFIG_IPSEC_AH_HMAC_SHA1
extern int ahhmacsha1_attach(void);
extern int ahhmacsha1_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int ahhmacsha1_zeroize(void);
extern int ahhmacsha1_print(void *, char *);
extern int ahhmacsha1_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *ahhmacsha1_input(struct sk_buff *, struct tdb *);
extern int ahhmacsha1_output(struct sk_buff *, struct tdb *);
#endif

#ifdef CONFIG_IPSEC_ESP_DES_CBC
extern int espdes_attach(void);
extern int espdes_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int espdes_zeroize(void);
extern int espdes_print(void *, char *);
extern int espdes_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *espdes_input(struct sk_buff *, struct tdb *);
extern int espdes_output(struct sk_buff *, struct tdb *);
#endif 

#ifdef CONFIG_IPSEC_ESP_DES_MD5
extern int espdesmd5_attach(void);
extern int espdesmd5_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int espdesmd5_zeroize(void);
extern int espdesmd5_print(void *, char *);
extern int espdesmd5_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *espdesmd5_input(struct sk_buff *, struct tdb *);
extern int espdesmd5_output(struct sk_buff *, struct tdb *);
#endif 

#ifdef CONFIG_IPSEC_ESP_3DES_MD5
extern int esp3desmd5_attach(void);
extern int esp3desmd5_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int esp3desmd5_zeroize(void);
extern int esp3desmd5_print(void *, char *);
extern int esp3desmd5_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *esp3desmd5_input(struct sk_buff *, struct tdb *);
extern int esp3desmd5_output(struct sk_buff *, struct tdb *);
#endif

#ifdef CONFIG_IPSEC_ESP_3DES_MD5_96
extern int esp3desmd596_attach(void);
extern int esp3desmd596_init(struct tdb *, struct xformsw *, struct encap_msghdr *);
extern int esp3desmd596_zeroize(void);
extern int esp3desmd596_print(void *, char *);
extern int esp3desmd596_room(struct tdb *, int, int, int *, int *);
extern struct sk_buff *esp3desmd596_input(struct sk_buff *, struct tdb *);
extern int esp3desmd596_output(struct sk_buff *, struct tdb *);
#endif 

#ifdef DEBUG_IPSEC_XFORM

extern int debug_xform;

#define DB_XF_INIT	0x0001

#endif
