#include <sys/cdefs.h>
#include <asm/types.h>
#include <linux/skbuff.h>
#include <linux/in.h>

#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#include "ipsec_ah.h"
#include "ipsec_esp.h"

typedef __u32 in_addr_t;

/* Values for the set/getsockopt calls */

/* These defines are compatible with NRL IPv6, however their semantics
   is different */

#define IPSEC_LEVEL_NONE	-1	/* send plaintext, accept any */
#define IPSEC_LEVEL_DEFAULT	0	/* encrypt/authenticate if possible */
					/* the default MUST be 0, because a */
					/* socket is initialized with 0's */
#define IPSEC_LEVEL_USE		1	/* use outbound, don't require inbound */
#define IPSEC_LEVEL_REQUIRE	2	/* require both directions */
#define IPSEC_LEVEL_UNIQUE	2	/* for compatibility only */

/* Socket options for the security layer (these are compatible with NRL IPv6) */
#define SO_SECURITY_AUTHENTICATION		0x1009	/* set AH */
#define SO_SECURITY_ENCRYPTION_TRANSPORT	0x1010	/* set ESP */
/* #define SO_SECURITY_ENCRYPTION_NETWORK	0x1011 -- unsupported */

__u32 arc4random(void);
