/*
 *
 *			   IPSEC for Linux
 *			 Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 *       Copyright (C) 1996-1997 Robert Muchsel <muchsel@acm.org>
 *       Copyright (C) 1995,96 M. Hauber, Ch. Schneider, G. Caronni
 *
 * Interface and firewall code ported from ENskip-0.67 by
 *  Petr Novak <pn@i.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _IPSEC_FW_H
#define _IPSEC_FW_H

#include <linux/firewall.h>

#define IPSEC_DISCARD	-1	/* we rely on PROCESSED > QUEUED > DISCARD */
#define IPSEC_QUEUED	0x00	/* don't change "DISCARD" -- is hard coded */
#define IPSEC_PROCESSED	0x01
#define IPSEC_P_AUTH	0x02 	/* bit flags or'ed with IPSEC_PROCESSED */
#define IPSEC_P_TUNNEL	0x04
#define IPSEC_P_ENCRYPT	0x10
#define IPSEC_P_DECRYPT	0x20

extern int interface_attach(void *, u_char *);
extern int interface_detach(void *, u_char *);
extern int interface_feed_out(struct sk_buff *);
extern int interface_feed_in(struct sk_buff *);

extern int interface_init(void);
extern int interface_exit(void);

extern int packet_nop(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int packet_accept(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int input_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int output_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int forward_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);

#ifdef DEBUG_IPSEC_TUNNEL

extern int debug_tunnel;

#define DB_TN_INIT	0x0001
#define DB_TN_XMIT	0x0010
#define DB_TN_OHDR	0x0020
#define DB_TN_CROUT	0x0040
#define DB_TN_OXFS	0x0080
#define DB_TN_REVEC	0x0100
#endif

#endif /* _IPSEC_FW_H */
