/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 * 
 * Changes by Angelos D. Keromytis and Niels Provos
 * ported from OpenBSD 2.2 by Petr Novak, <pn@i.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * $Id: ipsec_encap.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_encap.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Minor cosmetic changes.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * Minor Cleanup.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Declarations relevant to encapsulation-like operations.
 */

struct sockaddr_encap
{
	__u8	sen_len;		/* length */
	__u8	sen_family;		/* AF_ENCAP */
	__u16	sen_type;		/* see SENT_* */
	union
	{
		struct			/* SENT_IP4 */
		{
			struct in_addr Src;
			struct in_addr Dst;
		} Sip4;
	} Sen;
};

#define sen_ip_src	Sen.Sip4.Src
#define sen_ip_dst	Sen.Sip4.Dst

/*
 * The "type" is really part of the address as far as the routing
 * system is concerned. By using only one bit in the type field
 * for each type, we sort-of make sure that different types of
 * encapsulation addresses won't be matched against the wrong type.
 * 
 */

#define SENT_IP4	0x0001		/* data is two struct in_addr */
#define	SENT_IPSP	0x0002		/* data as in IP4 plus SPI */

#define SEN_HDRLEN	(2*sizeof(__u8)+sizeof(__u16))

#define SEN_IP4_SRCOFF	(0)
#define SEN_IP4_DSTOFF (sizeof (struct in_addr))
#define SEN_IP4_OPTOFF	(2 * sizeof (struct in_addr))

#define SEN_IP4_LEN	(SENT_HDRLEN + SENT_IP4_OPTOFF)


/*
 * An entry in the radix tree 
 */

struct rjtentry
{
	struct	radij_node rd_nodes[2];	/* tree glue, and other values */
#define	rd_key(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_key))
#define	rd_mask(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_mask))
	short	rd_flags;
	short	rd_count;
};

/*
 * An encapsulation route consists of a pointer to a 
 * radix tree entry and a SAID (a destination address/SPI pair).
 */

struct eroute
{
	struct rjtentry er_rjt;
	struct in_addr	er_dst;	/* XXX should it be sockaddr? */
	__u32		er_spi;
	struct sockaddr_encap er_eaddr;
	struct sockaddr_encap er_emask;
};

#ifdef DEBUG_IPSEC_EROUTE

extern int debug_eroute;

#define DB_ER_PROCFS	0x0001

#endif

#ifdef DEBUG_IPSEC_SPI

extern int debug_spi;

#define DB_SP_PROCFS	0x0001

#endif

