/*
 * convert from binary data (e.g. key) to ASCII form
 * Copyright (C) 1998, 1999  Henry Spencer.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/lgpl.txt>.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * RCSID $Id: datatoa.c,v 1.7 1999/11/30 04:12:53 henry Exp $
 */
#include "internal.h"
#include "freeswan.h"

/*
 - bytestoa - convert data bytes to ASCII
 */
size_t				/* true length (with NUL) for success */
bytestoa(src, srclen, format, dst, dstlen)
const char *src;
size_t srclen;
int format;			/* character indicating what format */
char *dst;			/* need not be valid if dstlen is 0 */
size_t dstlen;
{
	char *stop;
	size_t ndone;
	unsigned c;
	size_t nwanted;
	int dobreaks;
	static char hex[] = "0123456789abcdef";

	switch (format) {
	case 'x':
		dobreaks = 0;
		break;
	case 0:
	case 'h':
		dobreaks = 1;
		break;
	default:
		return 0;
		break;
	}

	switch (dstlen) {
	case 0:
		dst = hex;	/* point it somewhere valid */
		break;
	case 1:
		break;
	case 2:
		strcpy(dst, "0");
		dst += 1;
		break;
	default:
		strcpy(dst, "0x");
		dst += 2;
		break;
	}
	nwanted = 2;
	stop = dst + dstlen;

	ndone = 0;
	while (ndone < srclen) {
		c = (unsigned char)*src++;
		if (dst < stop)
			*dst++ = hex[c>>4];
		if (dst < stop)
			*dst++ = hex[c&0xf];
		nwanted += 2;
		ndone++;
		if (dobreaks && ndone % 4 == 0 && ndone < srclen) {
			if (dst < stop)
				*dst++ = '_';
			nwanted++;
		}
	}
	if (dst < stop)
		*dst++ = '\0';
	else if (dstlen > 0)
		*(stop-1) = '\0';
	nwanted++;

	return nwanted;
}

/*
 - datatoa - convert data to ASCII
 * backward-compatibility synonym for bytestoa
 */
size_t				/* true length (with NUL) for success */
datatoa(src, srclen, format, dst, dstlen)
const char *src;
size_t srclen;
int format;			/* character indicating what format */
char *dst;			/* need not be valid if dstlen is 0 */
size_t dstlen;
{
	return bytestoa(src, srclen, format, dst, dstlen);
}
