/*
 * FreeS/WAN specific PF_KEY headers
 * Copyright (C) 1999  Richard Guy Briggs.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: pfkey.h,v 1.15 1999/12/09 23:12:54 rgb Exp $
 */

#ifndef __NET_IPSEC_PF_KEY_H
#define __NET_IPSEC_PF_KEY_H
#ifdef __KERNEL__
extern void pfkey_proto_init(struct net_proto *pro);
extern struct proto_ops pfkey_proto_ops;
typedef struct sock pfkey_sock;
extern int debug_pfkey;

extern /* void */ int pfkey_init(void);
extern /* void */ int pfkey_cleanup(void);

extern struct sock *pfkey_sock_list;
struct socket_list
{
	struct socket *socketp;
	struct socket_list *next;
};

extern void pfkey_list_insert_socket(struct socket*, struct socket_list*);
extern void pfkey_list_remove_socket(struct socket*, struct socket_list*);
extern struct socket_list *pfkey_open_sockets;
extern struct socket_list *pfkey_registered_sockets;
extern uint8_t sadb_satype2proto[];

/* #if defined(__KERNEL__) || !defined(__GLIBC__) || (__GLIBC__ < 2) */
struct sockaddr_key
{
	uint16_t	key_family;	/* PF_KEY */
	uint16_t	key_pad;	/* not used */
	uint32_t	key_pid;	/* process ID */
};
/* #endif */ /* defined(__KERNEL__) || !defined(__GLIBC__) || (__GLIBC__ < 2) */
#endif /* __KERNEL__ */

struct key_opt
{
	uint32_t	key_pid;	/* process ID */
	struct sock	*sk;
};

#define key_pid(sk) ((struct key_opt*)&((sk)->protinfo))->key_pid

#define IPSEC_PFKEYv2_ALIGN (sizeof(uint64_t)/sizeof(uint8_t))
#define BITS_PER_OCTET 8
#define DIVUP(x,y) ((x + y -1) / y) /* divide, rounding upwards */
#define ALIGN(x,y) (DIVUP(x,y) * y) /* align on y boundary */

#define PFKEYv2_MAX_MSGSIZE 4096

/*
 * PF_KEYv2 permitted and required extensions in and out bitmaps
 */

extern unsigned int extensions_bitmaps[2/*in/out*/][2/*perm/req*/][SADB_MAX + 1/*ext*/];
#define EXT_BITS_IN 0
#define EXT_BITS_OUT 1
#define EXT_BITS_PERM 0
#define EXT_BITS_REQ 1

extern void pfkey_extensions_init(struct sadb_ext *extensions[SADB_EXT_MAX + 1]);
extern void pfkey_extensions_free(struct sadb_ext *extensions[SADB_EXT_MAX + 1]);
extern void pfkey_msg_free(struct sadb_msg *pfkey_msg);

extern int pfkey_msg_parse(struct sadb_msg *pfkey_msg,
			   int (*ext_parsers[])(struct sadb_ext* ),
			   struct sadb_ext **extensions,
			   int dir);

/*
 * PF_KEYv2 build function prototypes
 */

int
pfkey_msg_hdr_build(struct sadb_ext**	pfkey_ext,
		    uint8_t		msg_type,
		    uint8_t		satype,
		    uint8_t		msg_errno,
		    uint32_t		seq,
		    uint32_t		pid);

int
pfkey_sa_build(struct sadb_ext **	pfkey_ext,
	       uint16_t			exttype,
	       uint32_t			spi, /* in network order */
	       uint8_t			replay_window,
	       uint8_t			sa_state,
	       uint8_t			auth,
	       uint8_t			encrypt,
	       uint32_t			flags);

int
pfkey_lifetime_build(struct sadb_ext **	pfkey_ext,
		     uint16_t		exttype,
		     uint32_t		allocations,
		     uint64_t		bytes,
		     uint64_t		addtime,
		     uint64_t		usetime);

int
pfkey_address_build(struct sadb_ext**	pfkey_ext,
		    uint16_t		exttype,
		    uint8_t		proto,
		    uint8_t		prefixlen,
		    struct sockaddr*	address);

int
pfkey_key_build(struct sadb_ext**	pfkey_ext,
		uint16_t		exttype,
		uint16_t		key_bits,
		char*			key);

int
pfkey_ident_build(struct sadb_ext**	pfkey_ext,
		  uint16_t		exttype,
		  uint16_t		ident_type,
		  uint64_t		ident_id,
		  char*			ident_string);

int
pfkey_sens_build(struct sadb_ext**	pfkey_ext,
		 uint32_t		dpd,
		 uint8_t		sens_level,
		 uint8_t		sens_len,
		 uint8_t		integ_level,
		 uint8_t		integ_len);

int
pfkey_prop_build(struct sadb_ext**	pfkey_ext,
		 uint8_t		replay);

int
pfkey_supported_build(struct sadb_ext**	pfkey_ext,
		      uint16_t		exttype);

int
pfkey_spirange_build(struct sadb_ext**	pfkey_ext,
		     uint16_t		exttype,
		     uint32_t		min,
		     uint32_t		max);

int
pfkey_x_kmprivate_build(struct sadb_ext**	pfkey_ext);

int
pfkey_x_satype_build(struct sadb_ext**	pfkey_ext,
		     uint16_t		exttype,
		     uint8_t		satype);

int
pfkey_msg_build(struct sadb_ext *extensions[],
		int dir);

#endif /* __NET_IPSEC_PF_KEY_H */

/*
 * $Log: pfkey.h,v $
 * Revision 1.15  1999/12/09 23:12:54  rgb
 * Added macro for BITS_PER_OCTET.
 * Added argument to pfkey_sa_build() to do eroutes.
 *
 * Revision 1.14  1999/12/08 20:33:25  rgb
 * Changed sa_family_t to uint16_t for 2.0.xx compatibility.
 *
 * Revision 1.13  1999/12/07 19:53:40  rgb
 * Removed unused first argument from extension parsers.
 * Changed __u* types to uint* to avoid use of asm/types.h and
 * sys/types.h in userspace code.
 * Added function prototypes for pfkey message and extensions
 * initialisation and cleanup.
 *
 * Revision 1.12  1999/12/01 22:19:38  rgb
 * Change pfkey_sa_build to accept an SPI in network byte order.
 *
 * Revision 1.11  1999/11/27 11:55:26  rgb
 * Added extern sadb_satype2proto to enable moving protocol lookup table
 * to lib/pfkey_v2_parse.c.
 * Delete unused, moved typedefs.
 * Add argument to pfkey_msg_parse() for direction.
 * Consolidated the 4 1-d extension bitmap arrays into one 4-d array.
 *
 * Revision 1.10  1999/11/23 22:29:21  rgb
 * This file has been moved in the distribution from klips/net/ipsec to
 * lib.
 * Add macros for dealing with alignment and rounding up more opaquely.
 * The uint<n>_t type defines have been moved to freeswan.h to avoid
 * chicken-and-egg problems.
 * Add macros for dealing with alignment and rounding up more opaque.
 * Added prototypes for using extention header bitmaps.
 * Added prototypes of all the build functions.
 *
 * Revision 1.9  1999/11/20 21:59:48  rgb
 * Moved socketlist type declarations and prototypes for shared use.
 * Slightly modified scope of sockaddr_key declaration.
 *
 * Revision 1.8  1999/11/17 14:34:25  rgb
 * Protect sa_family_t from being used in userspace with GLIBC<2.
 *
 * Revision 1.7  1999/10/27 19:40:35  rgb
 * Add a maximum PFKEY packet size macro.
 *
 * Revision 1.6  1999/10/26 16:58:58  rgb
 * Created a sockaddr_key and key_opt socket extension structures.
 *
 * Revision 1.5  1999/06/10 05:24:41  rgb
 * Renamed variables to reduce confusion.
 *
 * Revision 1.4  1999/04/29 15:21:11  rgb
 * Add pfkey support to debugging.
 * Add return values to init and cleanup functions.
 *
 * Revision 1.3  1999/04/15 17:58:07  rgb
 * Add RCSID labels.
 *
 */
