(define (messages:block-filter-list)
  (let* ((start (if (and ui:index
			 (string->number ui:index))
		    (max 0 (min (- *messages:next-spot* 8)
				(string->number ui:index)))
		    (max 0 (- *messages:next-spot* 8))))
	 (stop (min (- *messages:next-spot* 1) (+ start 7))))
    (list
     (if (> start 0)
	 (list
	  "<a href = \"messages.html?"
	  (max 0 (- start 8))
	  "\">Earlier messages</a>")
	 '())
     (ui:pretty-html-list
      (map (lambda (index)
	     (let ((msg (messages:get-message index)))
	       (list "<a href = \"read-message.html?"
		     index
		     "\">\""
		     (messages:title msg)
		     "\", by "
		     (identity:description (messages:sender msg))
		     ": \""
		     (if (> (string-length (messages:text msg))
			    23)
			 (list (ui:line-literal (substring 
						 (messages:text msg) 0 20))
			       "...\"")
			 (list (ui:line-literal (messages:text msg))
			       "\""))
		     "</a>")))
	   (integers start stop)))
     (if (< stop (- *messages:next-spot* 1))
	 (list
	  "<a href = \"messages.html?"
	  (max 0 (min (+ start 8)
		      (- *messages:next-spot* 8)))
	  "\">Later messages</a>")
	 '()))))

(define (messages:regexp-filter-list)
  (let* ((start (if (and ui:index
			 (string->number ui:index))
		    (max 0 (min (- *messages:next-spot* 8)
				(string->number ui:index)))
		    (max 0 (- *messages:next-spot* 8))))
	 (stop (min (- *messages:next-spot* 1) (+ start 7))))
    (list
     (if (> start 0)
	 (list
	  "<a href = \"messages.html?"
	  (max 0 (- start 8))
	  "\">Earlier messages</a>")
	 '())
     (ui:pretty-html-list
      (map (lambda (index)
	     (let ((msg (messages:get-message index)))
	       (list "<a href = \"read-message.html?"
		     index
		     "\">\""
		     (messages:title msg)
		     "\", by "
		     (identity:description (messages:sender msg))
		     ": \""
		     (if (> (string-length (messages:text msg))
			    23)
			 (list (ui:line-literal (substring 
						 (messages:text msg) 0 20))
			       "...\"")
			 (list (ui:line-literal (messages:text msg))
			       "\""))
		     "</a>")))
	   (integers start stop)))
     (if (< stop (- *messages:next-spot* 1))
	 (list
	  "<a href = \"messages.html?"
	  (max 0 (min (+ start 8)
		      (- *messages:next-spot* 8)))
	  "\">Later messages</a>")
	 '()))))
