(yreq "Utilities/yenta-utils")

(define (document-changes:make-changes)
  (list
   (cond ((ui:from-form?)
	  (list
	   "<h1>Periodic search directories changed</h1>"
	   (cond ((equal? (ui:form-datum "kind") "regular")
		  (set! *interests:search-dirs* 
			(map expand-dir (ui:textarea->list
					 (ui:form-datum "search"))))
		  (cond ((ui:form-datum "now")
			 (interests:run-auto-search)
			 "I am searching the directories you specified.")
			(t
			 "I have noted the new directories.")))
		 ((equal? (ui:form-datum "kind") "once")
		  (when (interests:acquire-docs (expand-dir
						 (ui:form-datum "search")))
		    (scheduler:split
			(scheduler:when 
			    (not (scheduler:task-exists? "Document Finder"))
			  (interests:find-interests!))))
		  "I am searching the file or directory you specified.")
		 )))
	 (t
	  ""))
   "<h1>Current Info</h1>(As of "
   (date-string)
   ")<br>"
   "Directories currently searched:"
   (ui:pretty-list *interests:search-dirs*)
   "Search interval: "
   "<br>"
   "Last search: "
   (ctime *interests:last-collect*)
   "<br>"
   "Next search: "
   "<br>"
   "Documents not in any interests: "
   (compare:collection-length *interests:undone*)
   "<br>"
   "Current operation: "
   "None"
   "<br>"))
