(define (att-details:details)
  (let* ((id (ui:hex->bytes (ui:form-datum "id")))
	 (msg (ui:form-datum "msg"))
	 (att (identity:get-attestation id msg)))
    (cond (att
	   (let ((rows (list (attestations:generate-one-attestation-row att id))))
	     (attestations:generate-details-table-skeleton rows))
	   (format nil "<h2>Attestor</h2>~2&~A~2&<h2>Message</h2>~2&~A~2&<h2>Trusted?</h2>~2&~A~2&~A~&<a href = \"sign.html?id=~A&msg=~A\">Sign this attestation</a>"
		   (identity:description id)
		   msg
		   (string-capitalize (symbol->string (test-attestation att id))) ; Should be one of "Yes", "No", or "Maybe"
		   (attestations:generate-details-table att id)
		   (ui:form-datum "id")
		   (url-encode msg)))
	  (t
	   "<b>[No such attestation.]</b><p>")))) ; Can we get here?

(define (attestations:generate-details-table att id)
  (let ((rows (attestations:generate-details-signature-rows att id)))
    (cond ((not (or (null? rows)
		    (equal? rows "")))
	   (attestations:generate-details-table-skeleton rows))
	  (t "<b>[No such attestation.]</b><p>")))) ; Presumably, we can't get here, right?

(define (attestations:generate-details-table-skeleton rows)
  (format nil
"<table cellpadding=\"0\" cellspacing=\"~A\" border=\"0\">
  <tr>
    <th align=\"center\">Trusted</th>
    <th align=\"center\">Signer</th>
    <th align=\"center\">Date</th>
  </tr>
  ~A
</table>~%"
	  *attestations:table-cellspacing*
	  rows))

(define (attestations:generate-details-signature-rows att id)
  (let* ((sigs (cadr att))
	 (rows
	  (map (lambda (sig)
		 (attestations:generate-one-details-signature-row att id sig))
	       sigs)))
    (join-strings rows "")))

(define (attestations:generate-one-details-signature-row att id sig)
  (let* ((ident (car sig))
	 (timestamp (date-string (cadr sig)))
	 (trusted? (test-signature (car att) id sig)) ; In other words, is -this particular signature- trusted.  Says nothing about whole att.
	 (signer (identity:description-link-small ident "")))
    (format nil
"  <tr>
    <td valign=\"top\" align=\"center\">~A</td>
    <td valign=\"top\" align=\"center\">~A</td>
    <td valign=\"top\" align=\"center\"><font size=\"-1\">~A</font></td>
  </tr>~%"
            trusted? signer timestamp)))

;;;; Dead code:

; (define (att-details:details)
;   (let* ((id (ui:hex->bytes (ui:form-datum "id")))
; 	 (msg (ui:form-datum "msg"))
; 	 (att (identity:get-attestation id msg)))
;     (list
;      (cond (att
; 	    (list
; 	     "<h2> Attestor </h2>\n"
; 	     (identity:description id)
; 	     "<h2> Message </h2>\n"
; 	     msg
; 	     "<h2>Trusted?</h2>"
; 	     (let ((test (test-attestation att id)))
; 	       (if (eq? test 'yes)
; 		   "Yes"
; 		   (if (eq? test 'maybe)
; 		       "Maybe"
; 		       "No")))
; 	     "<h2> Signatures </h2>\n"
; 	     "<table border=\"1\"><tr><th>Signator</th><th>Date</th><th>Status</th></tr>\n"
; 	     (map (lambda (sig)
; 		    (let* ((t (cadr sig))
; 			   (i (car sig))
; 			   (v (test-signature msg id sig))
; 			   (p (identity:description-link-small i)))
; 		      (list
; 		       "<tr><td>"
; 		       p
; 		       "</td><td>"
; 		       (ctime t)
; 		       "</td><td>"
; 		       v
; 		       "</td></tr>")))
; 		  (cadr att))
; 	     "</table>"
; 	     "<form method = \"post\" action = \"sign.html\">"
; 	     "<input type = \"hidden\" name = \"id\" value = \""
; 	     (ui:bytes->hex id)
; 	     "\"><input type = \"hidden\" name = \"msg\" value = \""
; 	     msg
; 	     "\"><input type = \"submit\" value = \"Sign this attestation\"></form>"))
; 	   (t
; 	    (format #f 
; 		    "I do not recognize the attestation you gave me: ~A ~s"
; 		    (ui:bytes->hex-space id) msg)))
;      (if (equal? id *local-yenta-id*)
; 	 "<p><a href=\"attestations.html\">Return to your attestations</a>\n"
; 	 (list
; 	  "Return to information about "
; 	  (identity:description-link id))))))

;;; End of file.
