;;;; Create a ~/.savantrc if the user doesn't already have one.

;;; This is a short-term hack, until we're running a version of the Savant
;;; core that doesn't use .savantrc's at all.  Because of this, we label
;;; the file with a special template (see end), so we can tell if we're
;;; the ones who created any given .savantrc.  If we are, and this is a
;;; new enough Yenta not to need it at all, we'll delete it again.

(require 'format)

(define (interests:savantrc-pathname)
  (format nil "~A/.savantrc" (getenv "HOME")))

(define (interests:maybe-create-savantrc)
  (let ((path (interests:savantrc-pathname)))
    (unless (file-exists? path)
      (let ((file (open-output-file path))) ; If this doesn't work, an error will be signalled.
	(format file "~A" *interests:savantrc-contents*) ; %%% Presumably, the Yenta will die if we can't write; how to be graceful about this?
	(close-port file)))))

(define *interests:savantrc-contents*
"source_field_width	17
ellipses		true
document_windowing	true
lines_per_window	50
index_dotfiles		false

Template RMAIL
{
  Recognize 
    {startline, \"BABYL OPTIONS:\", ignore, \"\\n\",
     \"Version:\" ignore, \"\\n\",
     \"Labels:\" ignore, \"\\n\",
     \"Note:   This is the header of an rmail file.\\n\",
     \"Note:   If you are seeing it in rmail,\\n\",
     \"Note:    it means the file has no messages in it.\\n\"}
  Delimiter
    {\"^_^L\"}
  Format 
    {\"^_^L\\n\", ignore, startline, \"*** EOOH ***\\n\",
     {anyorder, {startline, \"From: \", SOURCE, \"\\n\"},
               {startline, \"Date: \", DATE, \"\\n\"},
               {startline, \"To: \", LOCATION, \"\\n\"},
               optional {startline, \"Subject: \", SUBJECT, \"\\n\"}},
     \"\\n\\n\", BODY}
}

Template plain_email
{
  Recognize 
    {anyorder {startline, \"From \"}}
  Delimiter
    {startline, \"From \"}
  Format 
    {startline, \"From \", ignore, 
        {anyorder optional {startline, \"From: \", SOURCE, \"\\n\"},
                  optional {startline, \"Date: \", DATE, \"\\n\"}, 
                  optional {startline, \"To: \", LOCATION, \"\\n\"}, 
                  optional {startline, \"Subject: \", SUBJECT, \"\\n\"}
        }
     \"\\n\\n\", BODY}
}


Template Jimminy
{
  Recognize {startline \"Jimminy-header\"}
  Delimiter
    {\"Jimminy-header <\"}   
  Format {
    startline \"Jimminy-header <\" LOCATION \"|\" SOURCE \"|\" SUBJECT \"|\" DATE \">\\n\"
    BODY}
}

Template FAQ
{
  Recognize 
    {startline \"Path: \",
     {anyorder, {startline, \"Newsgroups: \"},
	        {startline, \"From: \"},
	        {startline, \"Date: \"},
	        {startline, \"Subject: \"}}}
  Delimiter
    {startline \"Path: \"}
  Format 
    {startline \"Path: \", ignore, \"\\n\",
     {anyorder, {startline, \"Newsgroups: \", SOURCE, \"\\n\"},
                {startline, \"Date: \", DATE, \"\\n\"},
                {startline, \"Subject: \", SUBJECT, \"\\n\"}},
     \"\\n\\n\", BODY}
}

Template USENET
{
  Recognize 
    {startline \"Article \",
     {anyorder, {startline, \"Newsgroups: \"},
	        {startline, \"From: \"},
	        {startline, \"Date: \"},
	        {startline, \"Subject: \"}}}
  Delimiter
    {startline \"Article \"}
  Format 
    {startline \"Article \", ignore, \"\\n\",
     {anyorder, {startline, \"Newsgroups: \", SOURCE, \"\\n\"},
                {startline, \"Date: \", DATE, \"\\n\"},
                {startline, \"Subject: \", SUBJECT, \"\\n\"}},
     \"\\n\\n\", BODY}
}

Template LaTeX
{
  Recognize {anyof \"\\\\documentstyle\", \"\\\\documentclass\"}
  Format
    {{anyorder optional {\"\\\\title{\", SUBJECT, \"}\" }, 
               optional {\"\\\\author{\", SOURCE, \"}\" },
	       optional {\"\\\\date{\", DATE, \"}\" }}
     optional \"\\\\begin{document}\", BODY}
}

Template HTML
{
  Recognize 
    {anyof icase \"<html>\", icase \"<title>\", icase \"<a href=\", icase \"<p>\"}
  Format 
    {optional {icase \"<title>\", SUBJECT, icase \"</title>\"}, BODY}
}

Template INSPEC
{
  Recognize 
    {startline, \"  accession: \"}
  Delimiter
    {\"  accession:\"}
  Format 
    {startline, \"  accession: \", 
      {anyorder 
	{startline, \"  doc title:\", SUBJECT, \"\\n\"}
	{startline, \"   pub date:\", DATE, \"\\n\"}
	{startline, \"     author:\", SOURCE, \"\\n\"}
	{startline, \"   abstract:\", BODY, \"\\n\"}
      }
  }
}

Template ZephyrLog-annotated
{ 
  Recognize
    {startline, \"^A\", ignore}
  Delimiter
    {startline, \"^A\"}
  Format
    {startline, \"^A\", ignore, \"\", BODY}
}


Template ZephyrLog
{ 
  Recognize
    {startline, \"Auth: \", ignore}
  Delimiter
    {startline, \"Auth: \"}
  Format {
    startline, \"Auth: \", ignore, \"Date: \", DATE, \"Host: \", ignore, 
    \"\\nFrom:\", ignore, \"<\", SOURCE, \">\\n\\n\", BODY
  }
}

Template Bible
{
  Recognize
    {startline, \"^_\"}
  Delimiter
    {startline, \"^_\"}
  Format {
     startline, \"^_\", SUBJECT, \"  \", BODY
  }
}

Template PostScript
{
  Recognize {startline, \"%!PS-Adobe-\"}
  Reject
}

Template PDF
{
  Recognize {startline, \"%PDF-\"}
  Reject
}

Template HQX
{
  Recognize {startline, \"(This file must be converted with BinHex \", ignore, \")\\n\"}
  Reject
}

Template RCS-CONTROL
{
  Recognize 
   {
     startline, \"head\", ignore, \";\\n\",
     startline, \"access\", ignore, \";\\n\",
     startline, \"symbols\", ignore, \";\\n\"
   }

  Reject
}

Template YENTA-CREATED-THIS-FILE
{
  Recognize 
   {
     startline, \"Yenta created this file; if you do not delete this template, then a later release of Yenta will delete this file again.  This template exists because the Savant core provides no way to put comments into .savantrc files.\", ignore, \";\\n\"
   }

  Reject
}
")

;;; End of file.
