; -*- Scheme -*-
;
; $Id: string27.scm,v 1.1 1998/03/16 07:59:46 foner Exp $

(require 'substring:reverse!)
(require 'string:copy)

;+doc
; procedure: substring:reverse
; arguments: string start end
; signature: string x int x int -> string
; pre:       (<= 0 start end (string-length string))
;
; Returns a copy of STRING such that the characters between START
; (inclusive) and END (exclusive) are reversed.
;-doc

(define substring:reverse
  (lambda (string start end)
    (let ((r (string:copy string)))
      (substring:reverse! r start end)
      r)))

;------------

;+doc
; procedure: substring:reverse
; arguments: string start end
; signature: string x int x int -> string
; pre:       (<= 0 start end (string-length string))
;
; Returns a copy of STRING such that the characters between START
; (inclusive) and END (exclusive) are reversed.
;
; > (string:reverse "string")
; "gnirts"
; > (string:reverse "")
; ""
;-doc

(define string:reverse
  (lambda (string)
    (substring:reverse string 0 (string-length string))))

; eof
