; -*- Scheme -*-
;
; $Id: string20.scm,v 1.1 1998/03/16 07:59:42 foner Exp $

(require 'substring:center-with-padding!)

;+doc
; procedure: substring:center
; arguments: source start end size padding
; signature: string x integer x string -> string
; pre:       (and (<= start end (string-length source))
;                 (<= (- end start) size)
;                 (< 0 (string-length padding)))
;
; Returns a new string of length SIZE containing (SUBSTRING SOURCE
; START END) centered within it using PADDING to fill out either size
; of the SOURCE. 
;
; > (substring:center "Detroit" 0 7 10 "+")
; "+Detroit++"
; > (substring:center "Detroit" 0 7 20 "+*+")
; "+*++*+Detroit+*++*++"
; > (substring:center "Detroit" 3 7 10 "+")
; "+++roit+++"
; > (substring:center "Detroit" 3 7 10 "+*+")
; "+*+roit+*+"
;-doc

(define substring:center
  (lambda (s ss se sz p)
    (let ((r (make-string sz)))
      (substring:center-with-padding! s ss se p 0 (string-length p) r 0 sz)
      r)))

;-------------

;+doc
; procedure: string:center
; arguments: source size padding
; signature: string x integer x string -> string
; pre:       (and (> size (string-length source))
;                 (< 0 (string-length padding)))
;
; Returns a new string of length SIZE containing SOURCE centered within
; it using muliple copies of PADDING to fill out either size of the
; SOURCE.  The choice of what to do when it isn't possible to use a
; whole number of copies of PADDING is arbitrary.  Drop me a note if
; you prefer/can-justify a different choice.
;
; > (string:center "Detroit" 10 "+")
; "+Detroit++"
; > (string:center "Detroit" 20 "+*+")
; "+*++*+Detroit+*++*++"
;-doc

(define string:center
  (lambda (s sz p)
    (let ((r (make-string sz)))
      (substring:center-with-padding! s 0 (string-length s) p 0 (string-length p) r 0 sz)
      r)))

; eof
