; -*- Scheme -*-
;
; $Id: string16.scm,v 1.1 1998/03/16 07:59:39 foner Exp $

;+doc
; procedure: substring:downcase!
; arguments: string start end
; signature: string x int x int -> unspecified
; pre:       (<= 0 start end (string-length string))
;
; Modifies STRING such that every case-modifiable character betweeen
; START and END is coverted to lowercase.
;
; Some examples.  In each of the following, assume that "a" is
; initially defined to be "occlUDed cASEmenTs"
;
; > (substring:downcase! a 0 18)
; > a
; "occluded casements"
;
; > (substring:downcase! a 5 18)
; > a
; "occlUded casements"
;
; > (substring:downcase! a 5 15)
; > a
; "occlUded casemenTs"
;
;-doc

(define substring:downcase!
  (lambda (s ss se)
    (let loop ((i ss))
      (if (= i se)
	  i				; arbitrary return value
	  (begin
	    (string-set! s i (char-downcase (string-ref s i)))
	    (loop (+ i 1)))))))

;-------------

;+doc
; procedure: string:downcase!
; arguments: string 
; signature: string -> unspecified
;
; Modifies STRING such that every case-modifiable character
; lowercase.
;
; Some examples.  In the following, assume that "a" is
; initially defined to be "occlUDed cASEmenTs"
;
; > (substring:downcase! a)
; > a
; "occluded casements"
;
;-doc

(define string:downcase!
  (lambda (s)
    (substring:downcase! s 0 (string-length s))))

; eof
