; -*- Scheme -*-
;
; $Id: pathname21.scm,v 1.1 1998/03/16 07:59:15 foner Exp $

(require 'pathname:+type)

;+doc
; procedure: pathname:+type-string
; arguments: pathname type
; signature: pathname string -> pathname
; 
; Creates a new pathname consisting of PATHNAME with the type
; overriden with TYPE.  Some examples where P->S == PATHNAME->STRING
; and S->P == STRING->PATHNAME :-
;
; > (p->s (pathname+type-string (s->p "/usr/me/scm/pathname15.scm") "doc"))
; "/usr/me/scm/pathname15.doc"
;
; > (p->s (pathname+type-string (s->p "pathname15.scm") "doc"))
; "pathname15.doc"
;
; > (p->s (pathname+type-string (s->p "/usr/me/scm/pathname15") "doc"))
; "/usr/me/scm/pathname15.doc"
;
; > (p->s (pathname+type-string (s->p "/usr/me/scm/") "doc"))
; "/usr/me/scm/.doc"
;-doc

(define pathname:+type-string
  (lambda (p t)
    (pathname:+type p (if (zero? (string-length t)) #f t))))

; eof
